/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableExpansionChangeListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerEvent;
import org.gudy.azureus2.core3.global.GlobalManagerEventListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.TorrentMenuFancy;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.CompositeMinSize;
import org.gudy.azureus2.ui.swt.help.HealthHelpWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.views.DownloadActivityView;
import org.gudy.azureus2.ui.swt.views.FilesView;
import org.gudy.azureus2.ui.swt.views.FilesViewMenuUtil;
import org.gudy.azureus2.ui.swt.views.GeneralView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.PeersGraphicView;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.PiecesView;
import org.gudy.azureus2.ui.swt.views.PrivacyView;
import org.gudy.azureus2.ui.swt.views.TaggingView;
import org.gudy.azureus2.ui.swt.views.TorrentInfoView;
import org.gudy.azureus2.ui.swt.views.TorrentOptionsView;
import org.gudy.azureus2.ui.swt.views.TrackerView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.piece.PieceInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTPanelCreator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.table.painted.TableRowPainted;
import org.gudy.azureus2.ui.swt.views.utils.CategoryUIUtils;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTorrentsView
extends TableViewTab<DownloadManager>
implements GlobalManagerListener,
ParameterListener,
DownloadManagerListener,
TagTypeListener,
TagListener,
KeyListener,
TableLifeCycleListener,
TableViewSWTPanelCreator,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
TableViewFilterCheck.TableViewFilterCheckEx<DownloadManager>,
TableRowRefreshListener,
TableCountChangeListener,
TableExpansionChangeListener,
UIPluginViewToolBarListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static volatile Set<String> preferred_tracker_names;
    public static volatile boolean eta_absolute;
    public static volatile boolean progress_eta_absolute;
    private AzureusCore azureus_core;
    private GlobalManager globalManager;
    private GlobalManagerEventListener gm_event_listener = new GlobalManagerEventListener(){

        public void eventOccurred(GlobalManagerEvent event2) {
            TableRowCore row;
            DownloadManager dm;
            if (event2.getEventType() == 1 && MyTorrentsView.this.isOurDownloadManager(dm = event2.getDownload()) && (row = MyTorrentsView.this.tv.getRow(dm)) != null) {
                TableRowCore[] existing = MyTorrentsView.this.tv.getSelectedRows();
                if (existing != null) {
                    for (TableRowCore e : existing) {
                        if (e == row) continue;
                        e.setSelected(false);
                    }
                }
                if (!row.isSelected()) {
                    row.setSelected(true);
                }
            }
        }
    };
    private boolean supportsTabs;
    private Composite cTablePanel;
    private Font fontButton = null;
    protected Composite cCategoriesAndTags;
    private DragSource dragSource = null;
    private DropTarget dropTarget = null;
    protected Text txtFilter = null;
    private Menu tableHeaderMenu = null;
    private TimerEventPeriodic txtFilterUpdateEvent;
    private Tag[] currentTags;
    private List<Tag> allTags;
    private int drag_drop_line_start = -1;
    private TableRowCore[] drag_drop_rows = null;
    private boolean bDNDalwaysIncomplete;
    private TableViewSWT<DownloadManager> tv;
    private Composite cTableParentPanel;
    protected boolean viewActive;
    private TableSelectionListener defaultSelectedListener;
    private Composite filterParent;
    protected boolean neverShowCatOrTagButtons;
    private boolean rebuildListOnFocusGain = false;
    private Menu oldMenu;
    private boolean isCompletedOnly;
    private Class<?> forDataSourceType;
    private SelectionListener buttonSelectionListener;
    private Listener buttonHoverListener;
    private DropTargetListener buttonDropTargetListener;
    protected boolean isEmptyListOnNullDS;
    private FrequencyLimitedDispatcher refresh_limiter = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    MyTorrentsView.this.updateSelectedContent();
                }
            });
        }
    }, 250);
    private Set<Tag> pending_tag_changes;
    private static boolean registeredCoreSubViews;

    public MyTorrentsView(boolean supportsTabs) {
        super("MyTorrentsView");
        this.refresh_limiter.setSingleThreaded();
        this.pending_tag_changes = new HashSet<Tag>();
        this.supportsTabs = supportsTabs;
    }

    public MyTorrentsView(String propertiesPrefix, boolean supportsTabs) {
        super(propertiesPrefix);
        this.refresh_limiter.setSingleThreaded();
        this.pending_tag_changes = new HashSet<Tag>();
        this.supportsTabs = supportsTabs;
    }

    public MyTorrentsView(AzureusCore _azureus_core, String tableID, boolean isSeedingView, TableColumnCore[] basicItems, Text txtFilter, Composite cCatsAndTags, boolean supportsTabs) {
        super("MyTorrentsView");
        this.refresh_limiter.setSingleThreaded();
        this.pending_tag_changes = new HashSet<Tag>();
        this.txtFilter = txtFilter;
        this.cCategoriesAndTags = cCatsAndTags;
        this.supportsTabs = supportsTabs;
        this.init(_azureus_core, tableID, isSeedingView ? DownloadTypeComplete.class : DownloadTypeIncomplete.class, basicItems);
    }

    @Override
    public TableViewSWT<DownloadManager> initYourTableView() {
        return this.tv;
    }

    @Override
    public void tableViewTabInitComplete() {
        if (COConfigurationManager.getBooleanParameter("Library.showFancyMenu", true)) {
            Composite tableComposite = this.tv.getComposite();
            this.oldMenu = tableComposite.getMenu();
            Menu menu = new Menu((Control)tableComposite);
            tableComposite.setMenu(menu);
            menu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    if (!MyTorrentsView.this.showMyOwnMenu(e)) {
                        MyTorrentsView.this.oldMenu.setVisible(true);
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
        super.tableViewTabInitComplete();
    }

    protected boolean showMyOwnMenu(MenuEvent e) {
        boolean hasSelection;
        Display d = e.widget.getDisplay();
        if (d == null) {
            return false;
        }
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        DownloadManager[] dms = this.getSelectedDownloads();
        boolean bl = hasSelection = dms.length > 0;
        if (!hasSelection) {
            return false;
        }
        Point pt = e.display.getCursorLocation();
        pt = this.tv.getTableComposite().toControl(pt.x, pt.y);
        TableColumnCore column = this.tv.getTableColumnByOffset(pt.x);
        boolean isSeedingView = Download.class.equals(this.forDataSourceType) || DownloadTypeComplete.class.equals(this.forDataSourceType);
        new TorrentMenuFancy(this.tv, isSeedingView, this.getComposite().getShell(), dms, this.tv.getTableID()).showMenu(column, this.oldMenu);
        return true;
    }

    public void init(AzureusCore _azureus_core, String tableID, Class<?> forDataSourceType, TableColumnCore[] basicItems) {
        this.forDataSourceType = forDataSourceType;
        this.isCompletedOnly = forDataSourceType.equals(DownloadTypeComplete.class);
        this.tv = this.createTableView(forDataSourceType, tableID, basicItems);
        this.tv.setRowDefaultHeight(17);
        if (this.getRowDefaultHeight() > 0) {
            this.tv.setRowDefaultHeight(this.getRowDefaultHeight());
        }
        this.azureus_core = _azureus_core;
        this.globalManager = this.azureus_core.getGlobalManager();
        if (this.currentTags == null) {
            this.currentTags = new Tag[]{CategoryManager.getCategory(1)};
        }
        this.tv.addLifeCycleListener(this);
        this.tv.setMainPanelCreator(this);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
        if (this.tv.canHaveSubItems()) {
            this.tv.addRefreshListener(this);
            this.tv.addCountChangeListener(this);
            this.tv.addExpansionChangeListener(this);
        }
        this.tv.addTableDataSourceChangedListener(new TableDataSourceChangedListener(){

            public void tableDataSourceChanged(Object newDataSource) {
                if (newDataSource instanceof Tag[]) {
                    MyTorrentsView.this.neverShowCatOrTagButtons = true;
                    MyTorrentsView.this.setCurrentTags((Tag[])newDataSource);
                    return;
                }
                if (newDataSource instanceof Object[]) {
                    Object firstDS;
                    Object[] datasources = (Object[])newDataSource;
                    Object object = firstDS = datasources.length > 0 ? datasources[0] : null;
                    if (firstDS instanceof Tag) {
                        Tag[] tags = new Tag[datasources.length];
                        System.arraycopy(datasources, 0, tags, 0, datasources.length);
                        MyTorrentsView.this.setCurrentTags(tags);
                        return;
                    }
                }
                if (newDataSource instanceof Tag) {
                    MyTorrentsView.this.neverShowCatOrTagButtons = true;
                    MyTorrentsView.this.setCurrentTags(new Tag[]{(Tag)newDataSource});
                }
                if (newDataSource == null && MyTorrentsView.this.isEmptyListOnNullDS) {
                    MyTorrentsView.this.setCurrentTags(new Tag[0]);
                }
            }
        }, true);
        if (this.txtFilter != null) {
            Control[] children;
            this.filterParent = this.txtFilter.getParent();
            if (Constants.isWindows) {
                this.filterParent = this.filterParent.getParent();
            }
            Menu menuFilterHeader = this.getHeaderMenu((Control)this.txtFilter);
            this.filterParent.setMenu(menuFilterHeader);
            for (Control control : children = this.filterParent.getChildren()) {
                if (control == this.txtFilter) continue;
                control.setMenu(menuFilterHeader);
            }
        }
    }

    @Override
    public void tableViewInitialized() {
        this.tv.addKeyListener(this);
        this.createTabs();
        if (this.txtFilter == null) {
            this.tv.enableFilterCheck(null, this);
        }
        this.createDragDrop();
        Utils.getOffOfSWTThread(new AERunnable(){

            public void runSupport() {
                COConfigurationManager.addAndFireParameterListeners(new String[]{"DND Always In Incomplete", "User Mode", "Library.ShowCatButtons", "Library.ShowTagButtons", "Library.ShowTagButtons.CompOnly"}, MyTorrentsView.this);
                if (MyTorrentsView.this.currentTags != null) {
                    for (Tag tag : MyTorrentsView.this.currentTags) {
                        tag.addTagListener(MyTorrentsView.this, false);
                    }
                }
                TagManager tagManager = TagManagerFactory.getTagManager();
                TagType ttManual = tagManager.getTagType(3);
                TagType ttCat = tagManager.getTagType(1);
                ttManual.addTagTypeListener(MyTorrentsView.this, false);
                ttCat.addTagTypeListener(MyTorrentsView.this, false);
                MyTorrentsView.this.globalManager.addListener(MyTorrentsView.this, false);
                MyTorrentsView.this.globalManager.addEventListener(MyTorrentsView.this.gm_event_listener);
                DownloadManager[] dms = MyTorrentsView.this.globalManager.getDownloadManagers().toArray(new DownloadManager[0]);
                for (int i = 0; i < dms.length; ++i) {
                    DownloadManager dm = dms[i];
                    dm.addListener(MyTorrentsView.this);
                    if (MyTorrentsView.this.isOurDownloadManager(dm)) continue;
                    dms[i] = null;
                }
                MyTorrentsView.this.tv.addDataSources(dms);
                MyTorrentsView.this.tv.processDataSourceQueue();
            }
        });
        this.cTablePanel.layout();
    }

    private Menu getHeaderMenu(Control control) {
        if (this.tableHeaderMenu != null) {
            return this.tableHeaderMenu;
        }
        this.tableHeaderMenu = new Menu((Decorations)control.getShell(), 8);
        final MenuItem menuItemShowUptime = new MenuItem(this.tableHeaderMenu, 32);
        Messages.setLanguageText((Widget)menuItemShowUptime, "ConfigView.label.showuptime");
        menuItemShowUptime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("MyTorrentsView.showuptime", menuItemShowUptime.getSelection());
            }
        });
        final MenuItem menuItemShowRates = new MenuItem(this.tableHeaderMenu, 32);
        Messages.setLanguageText((Widget)menuItemShowRates, "label.show.selected.rates");
        menuItemShowRates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("MyTorrentsView.showrates", menuItemShowRates.getSelection());
            }
        });
        final MenuItem menuItemShowCatBut = new MenuItem(this.tableHeaderMenu, 32);
        Messages.setLanguageText((Widget)menuItemShowCatBut, "ConfigView.label.show.cat.but");
        menuItemShowCatBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("Library.ShowCatButtons", menuItemShowCatBut.getSelection());
            }
        });
        final MenuItem menuItemShowTagBut = new MenuItem(this.tableHeaderMenu, 32);
        Messages.setLanguageText((Widget)menuItemShowTagBut, "ConfigView.label.show.tag.but");
        menuItemShowTagBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("Library.ShowTagButtons", menuItemShowTagBut.getSelection());
            }
        });
        this.tableHeaderMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                menuItemShowUptime.setSelection(COConfigurationManager.getBooleanParameter("MyTorrentsView.showuptime"));
                menuItemShowRates.setSelection(COConfigurationManager.getBooleanParameter("MyTorrentsView.showrates"));
                menuItemShowCatBut.setSelection(COConfigurationManager.getBooleanParameter("Library.ShowCatButtons"));
                menuItemShowTagBut.setSelection(COConfigurationManager.getBooleanParameter("Library.ShowTagButtons"));
                menuItemShowCatBut.setEnabled(!MyTorrentsView.this.neverShowCatOrTagButtons);
                menuItemShowTagBut.setEnabled(!MyTorrentsView.this.neverShowCatOrTagButtons);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        return this.tableHeaderMenu;
    }

    @Override
    public void tableViewDestroyed() {
        this.tv.removeKeyListener(this);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    Utils.disposeSWTObjects(new Object[]{MyTorrentsView.this.dragSource, MyTorrentsView.this.dropTarget, MyTorrentsView.this.fontButton, MyTorrentsView.this.tableHeaderMenu});
                    MyTorrentsView.this.dragSource = null;
                    MyTorrentsView.this.dropTarget = null;
                    MyTorrentsView.this.fontButton = null;
                    MyTorrentsView.this.tableHeaderMenu = null;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        });
        Object[] dms = this.globalManager.getDownloadManagers().toArray();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = (DownloadManager)dms[i];
            dm.removeListener(this);
        }
        if (this.currentTags != null) {
            for (Tag tag : this.currentTags) {
                tag.removeTagListener(this);
            }
        }
        TagManager tagManager = TagManagerFactory.getTagManager();
        TagType ttManual = tagManager.getTagType(3);
        TagType ttCat = tagManager.getTagType(1);
        ttManual.removeTagTypeListener(this);
        ttCat.removeTagTypeListener(this);
        this.globalManager.removeListener(this);
        this.globalManager.removeEventListener(this.gm_event_listener);
        COConfigurationManager.removeParameterListener("DND Always In Incomplete", this);
        COConfigurationManager.removeParameterListener("Library.ShowCatButtons", this);
        COConfigurationManager.removeParameterListener("Library.ShowTagButtons", this);
        COConfigurationManager.removeParameterListener("Library.ShowTagButtons.CompOnly", this);
    }

    @Override
    public Composite createTableViewPanel(Composite composite) {
        this.cTableParentPanel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.cTableParentPanel.setLayout((Layout)layout);
        if (composite.getLayout() instanceof GridLayout) {
            this.cTableParentPanel.setLayoutData((Object)new GridData(1808));
        }
        this.cTablePanel = new Composite(this.cTableParentPanel, 0);
        this.cTablePanel.addListener(26, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.viewActive = true;
                MyTorrentsView.this.updateSelectedContent();
            }
        });
        this.cTablePanel.addListener(27, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.viewActive = false;
            }
        });
        GridData gridData = new GridData(1808);
        this.cTablePanel.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.cTablePanel.setLayout((Layout)layout);
        this.cTablePanel.layout();
        return this.cTablePanel;
    }

    private void createTabs() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.swt_createTabs();
            }
        });
    }

    private void swt_createTabs() {
        boolean catButtonsDisabled = this.neverShowCatOrTagButtons;
        if (!catButtonsDisabled) {
            catButtonsDisabled = !COConfigurationManager.getBooleanParameter("Library.ShowCatButtons");
        }
        List<Tag> tags_to_show = new ArrayList<Tag>();
        boolean tagButtonsDisabled = this.neverShowCatOrTagButtons;
        if (!tagButtonsDisabled) {
            boolean bl = tagButtonsDisabled = !COConfigurationManager.getBooleanParameter("Library.ShowTagButtons");
            if (!tagButtonsDisabled && !this.isCompletedOnly) {
                tagButtonsDisabled = COConfigurationManager.getBooleanParameter("Library.ShowTagButtons.CompOnly");
            }
        }
        if (!tagButtonsDisabled) {
            ArrayList<Tag> tagsManual = new ArrayList<Tag>(TagManagerFactory.getTagManager().getTagType(3).getTags());
            for (Tag tag : tagsManual) {
                if (!tag.isVisible()) continue;
                tags_to_show.add(tag);
            }
        }
        if (!catButtonsDisabled) {
            ArrayList<Tag> tagsCat = new ArrayList<Tag>(TagManagerFactory.getTagManager().getTagType(1).getTags());
            for (Tag tag : tagsCat) {
                if (!tag.isVisible()) continue;
                tags_to_show.add(tag);
            }
        }
        tags_to_show = TagUIUtils.sortTags(tags_to_show);
        this.buildHeaderArea();
        if (this.cCategoriesAndTags != null && !this.cCategoriesAndTags.isDisposed()) {
            Utils.disposeComposite(this.cCategoriesAndTags, false);
        }
        if (tags_to_show.size() > 0) {
            this.buildCatAndTag(tags_to_show);
        } else if (this.cTableParentPanel != null && !this.cTableParentPanel.isDisposed()) {
            this.cTableParentPanel.layout();
        }
    }

    private void buildHeaderArea() {
        RowLayout rowLayout;
        if (this.cCategoriesAndTags == null) {
            Color background;
            this.cCategoriesAndTags = new CompositeMinSize(this.cTableParentPanel, 0);
            ((CompositeMinSize)this.cCategoriesAndTags).setMinSize(new Point(-1, 24));
            GridData gridData = new GridData(131072, 0x1000000, true, false);
            this.cCategoriesAndTags.setLayoutData((Object)gridData);
            this.cCategoriesAndTags.moveAbove(null);
            if (this.filterParent != null && (background = this.filterParent.getBackground()) != null) {
                this.cCategoriesAndTags.setBackground(background);
                this.cTableParentPanel.setBackground(background);
            }
            this.cCategoriesAndTags.setBackgroundMode(2);
        } else if (this.cCategoriesAndTags.isDisposed()) {
            return;
        }
        if (this.cCategoriesAndTags.getLayout() instanceof RowLayout) {
            rowLayout = (RowLayout)this.cCategoriesAndTags.getLayout();
        } else {
            rowLayout = new RowLayout();
            this.cCategoriesAndTags.setLayout((Layout)rowLayout);
        }
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginLeft = 3;
        rowLayout.marginRight = 3;
        rowLayout.spacing = 0;
        rowLayout.wrap = true;
        Menu menu = this.getHeaderMenu((Control)this.cTableParentPanel);
        this.cTableParentPanel.setMenu(menu);
        if (Constants.isOSX) {
            this.cTableParentPanel.addListener(35, new Listener(){

                public void handleEvent(Event event2) {
                    Display display = MyTorrentsView.this.cTableParentPanel.getDisplay();
                    Point pp_rel = display.map(null, (Control)MyTorrentsView.this.cTableParentPanel, event2.x, event2.y);
                    Control hit = Utils.findChild(MyTorrentsView.this.cTableParentPanel, pp_rel.x, pp_rel.y);
                    event2.doit = hit == MyTorrentsView.this.cTableParentPanel;
                }
            });
        }
        this.tv.enableFilterCheck(this.txtFilter, this);
    }

    private void buildCatAndTag(List<Tag> tags) {
        if (tags.size() == 0) {
            return;
        }
        int iFontPixelsHeight = 10;
        int iFontPointHeight = iFontPixelsHeight * 72 / this.cCategoriesAndTags.getDisplay().getDPI().y;
        Label spacer = null;
        int max_rd_height = 0;
        this.allTags = tags;
        if (this.buttonSelectionListener == null) {
            this.buttonSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean add = e.stateMask == SWT.MOD1;
                    Button curButton = (Button)e.widget;
                    boolean isEnabled = curButton.getSelection();
                    Tag tag = (Tag)curButton.getData("Tag");
                    if (!isEnabled) {
                        MyTorrentsView.this.removeTagFromCurrent(tag);
                    } else if (add) {
                        Category catAll = CategoryManager.getCategory(1);
                        if (tag.equals(catAll)) {
                            MyTorrentsView.this.setCurrentTags(new Tag[]{catAll});
                        } else {
                            Object[] newTags = new Tag[MyTorrentsView.this.currentTags.length + 1];
                            System.arraycopy(MyTorrentsView.this.currentTags, 0, newTags, 0, MyTorrentsView.this.currentTags.length);
                            newTags[((MyTorrentsView)MyTorrentsView.this).currentTags.length] = tag;
                            newTags = (Tag[])MyTorrentsView.this.removeFromArray(newTags, catAll);
                            MyTorrentsView.this.setCurrentTags((Tag[])newTags);
                        }
                    } else {
                        MyTorrentsView.this.setCurrentTags(new Tag[]{(Tag)curButton.getData("Tag")});
                    }
                    Control[] controls = curButton.getParent().getChildren();
                    for (int i = 0; i < controls.length; ++i) {
                        if (!(controls[i] instanceof Button)) continue;
                        Button b = (Button)controls[i];
                        Tag btag = (Tag)b.getData("Tag");
                        b.setSelection(MyTorrentsView.this.isCurrent(btag));
                    }
                }
            };
            this.buttonHoverListener = new Listener(){

                public void handleEvent(Event event2) {
                    Button curButton = (Button)event2.widget;
                    Tag tag = (Tag)curButton.getData("Tag");
                    if (!(tag instanceof Category)) {
                        curButton.setToolTipText(TagUIUtils.getTagTooltip(tag, true));
                        return;
                    }
                    Category category = (Category)tag;
                    List<DownloadManager> dms = category.getDownloadManagers(MyTorrentsView.this.globalManager.getDownloadManagers());
                    long ttlActive = 0L;
                    long ttlSize = 0L;
                    long ttlRSpeed = 0L;
                    long ttlSSpeed = 0L;
                    int count = 0;
                    for (DownloadManager dm : dms) {
                        if (!category.hasTaggable(dm)) continue;
                        ++count;
                        if (dm.getState() == 50 || dm.getState() == 60) {
                            ++ttlActive;
                        }
                        DownloadManagerStats stats2 = dm.getStats();
                        ttlSize += stats2.getSizeExcludingDND();
                        ttlRSpeed += stats2.getDataReceiveRate();
                        ttlSSpeed += stats2.getDataSendRate();
                    }
                    String up_details = "";
                    String down_details = "";
                    if (category.getType() != 1) {
                        String up_str = MessageText.getString("GeneralView.label.maxuploadspeed");
                        String down_str = MessageText.getString("GeneralView.label.maxdownloadspeed");
                        String unlimited_str = MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited");
                        int up_speed = category.getUploadSpeed();
                        int down_speed = category.getDownloadSpeed();
                        up_details = up_str + ": " + (up_speed == 0 ? unlimited_str : DisplayFormatters.formatByteCountToKiBEtc(up_speed));
                        down_details = down_str + ": " + (down_speed == 0 ? unlimited_str : DisplayFormatters.formatByteCountToKiBEtc(down_speed));
                    }
                    if (count == 0) {
                        curButton.setToolTipText(down_details + "\n" + up_details + "\nTotal: 0");
                        return;
                    }
                    curButton.setToolTipText((up_details.length() == 0 ? "" : down_details + "\n" + up_details + "\n") + "Total: " + count + "\n" + "Downloading/Seeding: " + ttlActive + "\n" + "\n" + "Total Speed: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlRSpeed) + " / " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlSSpeed) + "\n" + "Average Speed: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlRSpeed / (ttlActive == 0L ? 1L : ttlActive)) + " / " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlSSpeed / (ttlActive == 0L ? 1L : ttlActive)) + "\n" + "Size: " + DisplayFormatters.formatByteCountToKiBEtc(ttlSize));
                }
            };
            this.buttonDropTargetListener = new DropTargetAdapter(){

                public void dragOver(DropTargetEvent e) {
                    if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                        boolean doAdd = false;
                        Control curButton = ((DropTarget)e.widget).getControl();
                        Tag tag = (Tag)curButton.getData("Tag");
                        Object[] ds = MyTorrentsView.this.tv.getSelectedDataSources().toArray();
                        if (tag != null) {
                            for (Object obj : ds) {
                                DownloadManager dm;
                                if (!(obj instanceof DownloadManager) || tag.hasTaggable(dm = (DownloadManager)obj)) continue;
                                doAdd = true;
                                break;
                            }
                        }
                        e.detail = doAdd ? 1 : 2;
                    } else {
                        e.detail = 0;
                    }
                }

                public void drop(DropTargetEvent e) {
                    e.detail = 0;
                    if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                        DownloadManager dm;
                        MyTorrentsView.this.drag_drop_line_start = -1;
                        MyTorrentsView.access$1602(MyTorrentsView.this, null);
                        Object[] ds = MyTorrentsView.this.tv.getSelectedDataSources().toArray();
                        Control curButton = ((DropTarget)e.widget).getControl();
                        Tag tag = (Tag)curButton.getData("Tag");
                        if (tag instanceof Category) {
                            TorrentUtil.assignToCategory(ds, (Category)tag);
                            return;
                        }
                        boolean doAdd = false;
                        for (Object obj : ds) {
                            if (!(obj instanceof DownloadManager) || tag.hasTaggable(dm = (DownloadManager)obj)) continue;
                            doAdd = true;
                            break;
                        }
                        for (Object obj : ds) {
                            if (!(obj instanceof DownloadManager)) continue;
                            dm = (DownloadManager)obj;
                            if (doAdd) {
                                tag.addTaggable(dm);
                                continue;
                            }
                            tag.removeTaggable(dm);
                        }
                    }
                }
            };
        }
        for (Tag tag : tags) {
            RowData rd;
            boolean isCat = tag instanceof Category;
            Button button = new Button(this.cCategoriesAndTags, 2);
            if (isCat) {
                if (spacer == null) {
                    spacer = new Label(this.cCategoriesAndTags, 0);
                    rd = new RowData();
                    rd.width = 8;
                    spacer.setLayoutData((Object)rd);
                    spacer.moveAbove(null);
                }
                button.moveAbove(spacer);
            }
            button.addKeyListener((KeyListener)this);
            if (this.fontButton == null) {
                Font f = button.getFont();
                FontData fd = f.getFontData()[0];
                fd.setHeight(iFontPointHeight);
                this.fontButton = new Font((Device)this.cCategoriesAndTags.getDisplay(), fd);
            }
            button.setText("|");
            button.setFont(this.fontButton);
            button.pack(true);
            if (button.computeSize((int)100, (int)-1).y > 0) {
                int rd_height;
                rd = new RowData();
                rd.height = rd_height = button.computeSize((int)100, (int)-1).y - 2 + button.getBorderWidth() * 2;
                max_rd_height = Math.max(max_rd_height, rd_height);
                button.setLayoutData((Object)rd);
            }
            String tag_name = tag.getTagName(true);
            button.setText(tag_name);
            button.setData("Tag", (Object)tag);
            if (this.isCurrent(tag)) {
                button.setSelection(true);
            }
            button.addSelectionListener(this.buttonSelectionListener);
            button.addListener(32, this.buttonHoverListener);
            final DropTarget tabDropTarget = new DropTarget((Control)button, 23);
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            tabDropTarget.setTransfer(types);
            tabDropTarget.addDropListener(this.buttonDropTargetListener);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!tabDropTarget.isDisposed()) {
                        tabDropTarget.dispose();
                    }
                }
            });
            Menu menu = new Menu((Control)button);
            button.setMenu(menu);
            if (isCat) {
                CategoryUIUtils.setupCategoryMenu(menu, (Category)tag);
                continue;
            }
            TagUIUtils.createSideBarMenuItems(menu, tag);
        }
        if (max_rd_height > 0) {
            RowLayout layout = (RowLayout)this.cCategoriesAndTags.getLayout();
            int top_margin = (24 - max_rd_height + 1) / 2;
            if (top_margin > 0) {
                layout.marginTop = top_margin;
            }
        }
        this.cCategoriesAndTags.getParent().layout(true, true);
    }

    public boolean isOurDownloadManager(DownloadManager dm) {
        if (!this.isInTags(dm, this.currentTags)) {
            return false;
        }
        if (Download.class.equals(this.forDataSourceType)) {
            return true;
        }
        boolean bCompleted = dm.isDownloadComplete(this.bDNDalwaysIncomplete);
        boolean bOurs = bCompleted && this.isCompletedOnly || !bCompleted && !this.isCompletedOnly;
        return bOurs;
    }

    @Override
    public boolean filterCheck(DownloadManager dm, String sLastSearch, boolean bRegexSearch) {
        boolean bOurs;
        if (dm == null) {
            return false;
        }
        if (sLastSearch.length() > 0) {
            try {
                String comment = dm.getDownloadState().getUserComment();
                if (comment == null) {
                    comment = "";
                }
                String[][] name_mapping = new String[][]{{"", dm.getDisplayName()}, {"t:", ""}, {"st:", "" + dm.getState()}, {"c:", comment}, {"f:", ""}};
                Object o_name = name_mapping[0][1];
                String tmpSearch = sLastSearch;
                for (int i = 1; i < name_mapping.length; ++i) {
                    ArrayList<String> names;
                    if (!tmpSearch.startsWith(name_mapping[i][0])) continue;
                    tmpSearch = tmpSearch.substring(name_mapping[i][0].length());
                    if (i == 1) {
                        names = new ArrayList<String>();
                        o_name = names;
                        TOTorrent t = dm.getTorrent();
                        names.add(t.getAnnounceURL().getHost());
                        TOTorrentAnnounceURLSet[] sets = t.getAnnounceURLGroup().getAnnounceURLSets();
                        for (TOTorrentAnnounceURLSet set : sets) {
                            URL[] urls;
                            for (URL u : urls = set.getAnnounceURLs()) {
                                names.add(u.getHost());
                            }
                        }
                        continue;
                    }
                    if (i == 4) {
                        names = new ArrayList();
                        o_name = names;
                        DiskManagerFileInfoSet file_set = dm.getDiskManagerFileInfoSet();
                        DiskManagerFileInfo[] files = file_set.getFiles();
                        for (DiskManagerFileInfo f : files) {
                            File file = f.getFile(true);
                            String name = tmpSearch.contains(File.separator) ? file.getAbsolutePath() : file.getName();
                            names.add(name);
                        }
                        continue;
                    }
                    o_name = name_mapping[i][1];
                }
                String s = bRegexSearch ? tmpSearch : "\\Q" + tmpSearch.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
                boolean match_result = true;
                if (bRegexSearch && s.startsWith("!")) {
                    s = s.substring(1);
                    match_result = false;
                }
                Pattern pattern = RegExUtil.getCachedPattern("tv:search", s, 2);
                if (o_name instanceof String) {
                    bOurs = pattern.matcher((CharSequence)o_name).find() == match_result;
                } else {
                    List names = (List)o_name;
                    bOurs = !match_result;
                    for (String name : names) {
                        if (!pattern.matcher(name).find()) continue;
                        bOurs = match_result;
                    }
                }
            }
            catch (Exception e) {
                bOurs = true;
            }
        } else {
            bOurs = true;
        }
        return bOurs;
    }

    @Override
    public void filterSet(final String filter2) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Object x;
                if (MyTorrentsView.this.txtFilter != null && (x = MyTorrentsView.this.filterParent.getData("ViewUtils:ViewTitleExtraInfo")) instanceof ViewUtils.ViewTitleExtraInfo) {
                    boolean enabled;
                    boolean bl = enabled = filter2.length() > 0;
                    if (enabled) {
                        if (MyTorrentsView.this.txtFilterUpdateEvent == null) {
                            MyTorrentsView.this.txtFilterUpdateEvent = SimpleTimer.addPeriodicEvent("MTV:updater", 1000L, new TimerEventPerformer(){

                                public void perform(TimerEvent event2) {
                                    Utils.execSWTThread(new AERunnable(){

                                        public void runSupport() {
                                            if (MyTorrentsView.this.txtFilterUpdateEvent != null) {
                                                if (MyTorrentsView.this.tv.isDisposed()) {
                                                    MyTorrentsView.this.txtFilterUpdateEvent.cancel();
                                                    MyTorrentsView.this.txtFilterUpdateEvent = null;
                                                } else {
                                                    MyTorrentsView.this.viewChanged(MyTorrentsView.this.tv);
                                                }
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    } else if (MyTorrentsView.this.txtFilterUpdateEvent != null) {
                        MyTorrentsView.this.txtFilterUpdateEvent.cancel();
                        MyTorrentsView.this.txtFilterUpdateEvent = null;
                    }
                    ((ViewUtils.ViewTitleExtraInfo)x).setEnabled(MyTorrentsView.this.tv.getComposite(), enabled);
                }
            }
        });
    }

    @Override
    public void viewChanged(final TableView<DownloadManager> view) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.swt_viewChanged(view);
            }
        });
    }

    private void swt_viewChanged(TableView<DownloadManager> view) {
        Object x;
        if (this.filterParent != null && !this.filterParent.isDisposed() && (x = this.filterParent.getData("ViewUtils:ViewTitleExtraInfo")) instanceof ViewUtils.ViewTitleExtraInfo) {
            TableRowCore[] rows = view.getRows();
            int active = 0;
            for (TableRowCore row : rows) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                int state = dm.getState();
                if (state != 50 && state != 60) continue;
                ++active;
            }
            ((ViewUtils.ViewTitleExtraInfo)x).update(this.tv.getComposite(), rows.length, active);
        }
    }

    @Override
    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
        this.refreshTorrentMenu();
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
        this.refreshTorrentMenu();
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        this.updateSelectedContent();
        this.refreshTorrentMenu();
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    private void updateSelectedContentRateLimited() {
        this.refresh_limiter.dispatch();
    }

    public void updateSelectedContent() {
        this.updateSelectedContent(false);
    }

    public void updateSelectedContent(boolean force) {
        if (this.cTablePanel == null || this.cTablePanel.isDisposed()) {
            return;
        }
        if (!this.isTableFocus() && !force) {
            return;
        }
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        ArrayList<SelectedContent> listSelected = new ArrayList<SelectedContent>(dataSources.length);
        for (Object ds : dataSources) {
            if (ds instanceof DownloadManager) {
                listSelected.add(new SelectedContent((DownloadManager)ds));
                continue;
            }
            if (!(ds instanceof DiskManagerFileInfo)) continue;
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            listSelected.add(new SelectedContent(fileInfo2.getDownloadManager(), fileInfo2.getIndex()));
        }
        ISelectedContent[] content = listSelected.toArray(new SelectedContent[0]);
        SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), content, this.tv);
    }

    private void refreshTorrentMenu() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null && uiFunctions instanceof UIFunctionsSWT) {
            ((UIFunctionsSWT)uiFunctions).refreshTorrentMenu();
        }
    }

    public DownloadManager[] getSelectedDownloads() {
        Object[] data_sources = this.tv.getSelectedDataSources().toArray();
        ArrayList<DownloadManager> list = new ArrayList<DownloadManager>();
        for (Object ds : data_sources) {
            if (!(ds instanceof DownloadManager)) continue;
            list.add((DownloadManager)ds);
        }
        return list.toArray(new DownloadManager[0]);
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int keyMask) {
        if (this.defaultSelectedListener != null) {
            this.defaultSelectedListener.defaultSelected(rows, keyMask);
            return;
        }
        this.showSelectedDetails();
    }

    private void showSelectedDetails() {
        Object[] dm_sources = this.tv.getSelectedDataSources().toArray();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        for (int i = 0; i < dm_sources.length; ++i) {
            if (!(dm_sources[i] instanceof DownloadManager) || uiFunctions == null) continue;
            uiFunctions.getMDI().showEntryByID("DMDetails", dm_sources[i]);
        }
    }

    public void overrideDefaultSelected(TableSelectionListener defaultSelectedListener) {
        this.defaultSelectedListener = defaultSelectedListener;
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("health")) {
            MenuItem item = new MenuItem(menuThisColumn, 8);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.health");
            Utils.setMenuItemImage(item, "st_explain");
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    HealthHelpWindow.show(Display.getDefault());
                }
            });
        } else if (sColumnName.equals("trackername")) {
            MenuItem item = new MenuItem(menuThisColumn, 8);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.trackername.editprefs");
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("trackername.prefs.title", "trackername.prefs.message");
                    entryWindow.setPreenteredText(COConfigurationManager.getStringParameter("mtv.trackername.pref.hosts", ""), true);
                    entryWindow.selectPreenteredText(false);
                    entryWindow.prompt();
                    if (entryWindow.hasSubmittedInput()) {
                        String text = entryWindow.getSubmittedInput();
                        COConfigurationManager.setParameter("mtv.trackername.pref.hosts", text.trim());
                    }
                }
            });
        } else if (sColumnName.equals("eta") || sColumnName.equals("smootheta")) {
            final MenuItem item = new MenuItem(menuThisColumn, 32);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.eta.abs");
            item.setSelection(eta_absolute);
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    eta_absolute = item.getSelection();
                    MyTorrentsView.this.tv.columnInvalidate("eta");
                    MyTorrentsView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("mtv.eta.show_absolute", eta_absolute);
                }
            });
        } else if (sColumnName.equals("ProgressETA")) {
            final MenuItem item = new MenuItem(menuThisColumn, 32);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.eta.abs");
            item.setSelection(progress_eta_absolute);
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    progress_eta_absolute = item.getSelection();
                    MyTorrentsView.this.tv.columnInvalidate("ProgressETA");
                    MyTorrentsView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("mtv.progress_eta.show_absolute", progress_eta_absolute);
                }
            });
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        boolean hasSelection;
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        DownloadManager[] dms = this.getSelectedDownloads();
        if (dms.length == 0 && dataSources.length > 0) {
            ArrayList<DiskManagerFileInfo> listFileInfos = new ArrayList<DiskManagerFileInfo>();
            DownloadManager firstFileDM = null;
            for (Object ds : dataSources) {
                if (!(ds instanceof DiskManagerFileInfo)) continue;
                DiskManagerFileInfo info = (DiskManagerFileInfo)ds;
                if (firstFileDM != null && !firstFileDM.equals(info.getDownloadManager())) break;
                firstFileDM = info.getDownloadManager();
                listFileInfos.add(info);
            }
            if (listFileInfos.size() > 0) {
                FilesViewMenuUtil.fillMenu(this.tv, menu, firstFileDM, listFileInfos.toArray(new DiskManagerFileInfo[0]));
                return;
            }
        }
        boolean bl = hasSelection = dms.length > 0;
        if (hasSelection) {
            boolean isSeedingView = Download.class.equals(this.forDataSourceType) || DownloadTypeComplete.class.equals(this.forDataSourceType);
            TorrentUtil.fillTorrentMenu(menu, dms, this.azureus_core, this.cTablePanel, true, isSeedingView ? 2 : 1, this.tv);
            new MenuItem(menu, 2);
        }
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
                this.dropTarget.dispose();
            }
            this.dragSource = this.tv.createDragSource(3);
            if (this.dragSource != null) {
                this.dragSource.setTransfer(types);
                this.dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
                    private String eventData;

                    public void dragStart(DragSourceEvent event2) {
                        Object[] selectedDataSources;
                        TableRowCore[] rows = MyTorrentsView.this.tv.getSelectedRows();
                        if (rows.length != 0) {
                            event2.doit = true;
                            MyTorrentsView.this.drag_drop_line_start = rows[0].getIndex();
                            MyTorrentsView.access$1602(MyTorrentsView.this, rows);
                        } else {
                            event2.doit = false;
                            MyTorrentsView.this.drag_drop_line_start = -1;
                            MyTorrentsView.access$1602(MyTorrentsView.this, null);
                        }
                        boolean onlyDMs = true;
                        StringBuffer sb = new StringBuffer();
                        for (Object ds : selectedDataSources = MyTorrentsView.this.tv.getSelectedDataSources(true)) {
                            DiskManagerFileInfo fileInfo2;
                            DownloadManager dm;
                            TOTorrent torrent;
                            if (ds instanceof DownloadManager) {
                                DownloadManager dm2 = (DownloadManager)ds;
                                TOTorrent torrent2 = dm2.getTorrent();
                                if (torrent2 == null) continue;
                                try {
                                    sb.append(torrent2.getHashWrapper().toBase32String());
                                    sb.append('\n');
                                }
                                catch (TOTorrentException e) {}
                                continue;
                            }
                            if (!(ds instanceof DiskManagerFileInfo) || (torrent = (dm = (fileInfo2 = (DiskManagerFileInfo)ds).getDownloadManager()).getTorrent()) == null) continue;
                            try {
                                sb.append(torrent.getHashWrapper().toBase32String());
                                sb.append(';');
                                sb.append(fileInfo2.getIndex());
                                sb.append('\n');
                                onlyDMs = false;
                            }
                            catch (TOTorrentException e) {
                                // empty catch block
                            }
                        }
                        this.eventData = (onlyDMs ? "DownloadManager\n" : "DiskManagerFileInfo\n") + sb.toString();
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = this.eventData;
                    }
                });
            }
            this.dropTarget = this.tv.createDropTarget(31);
            if (this.dropTarget != null) {
                this.dropTarget.setTransfer(new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){
                    Point enterPoint = null;

                    public void dropAccept(DropTargetEvent event2) {
                        event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                    }

                    public void dragEnter(DropTargetEvent event2) {
                        if (MyTorrentsView.this.drag_drop_line_start < 0) {
                            if (event2.detail != 1) {
                                if ((event2.operations & 4) > 0) {
                                    event2.detail = 4;
                                } else if ((event2.operations & 1) > 0) {
                                    event2.detail = 1;
                                }
                            }
                        } else if (TextTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                            event2.detail = MyTorrentsView.this.tv.getTableRowWithCursor() == null ? 0 : 2;
                            event2.feedback = 8;
                            this.enterPoint = new Point(event2.x, event2.y);
                        }
                    }

                    public void dragLeave(DropTargetEvent event2) {
                        super.dragLeave(event2);
                        MyTorrentsView.this.tv.getComposite().redraw();
                    }

                    public void dragOver(DropTargetEvent event2) {
                        if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                            if (MyTorrentsView.this.drag_drop_rows.length > 0 && !(MyTorrentsView.this.drag_drop_rows[0].getDataSource(true) instanceof DownloadManager)) {
                                event2.detail = 0;
                                return;
                            }
                            TableRowCore row = MyTorrentsView.this.tv.getTableRowWithCursor();
                            if (row instanceof TableRowPainted) {
                                Rectangle bounds = ((TableRowPainted)row).getBounds();
                                MyTorrentsView.this.tv.getComposite().redraw();
                                MyTorrentsView.this.tv.getComposite().update();
                                GC gc = new GC((Drawable)MyTorrentsView.this.tv.getComposite());
                                gc.setLineWidth(2);
                                gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
                                gc.dispose();
                            }
                            event2.detail = row == null ? 0 : 2;
                            event2.feedback = 8 | (this.enterPoint != null && this.enterPoint.y > event2.y ? 2 : 4);
                        }
                    }

                    public void drop(DropTargetEvent event2) {
                        if (!(event2.data instanceof String)) {
                            TorrentOpener.openDroppedTorrents(event2, true);
                            return;
                        }
                        String data = (String)event2.data;
                        if (data.startsWith("DiskManagerFileInfo\n")) {
                            return;
                        }
                        if (!data.startsWith("DownloadManager\n")) {
                            TorrentOpener.openDroppedTorrents(event2, true);
                            return;
                        }
                        event2.detail = 0;
                        if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                            int drag_drop_line_end;
                            event2.detail = 0;
                            TableRowCore row = MyTorrentsView.this.tv.getRow(event2);
                            if (row == null) {
                                return;
                            }
                            if (row.getParentRowCore() != null) {
                                row = row.getParentRowCore();
                            }
                            if ((drag_drop_line_end = row.getIndex()) != MyTorrentsView.this.drag_drop_line_start) {
                                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                                MyTorrentsView.this.moveRowsTo(MyTorrentsView.this.drag_drop_rows, dm.getPosition());
                                event2.detail = 2;
                            }
                            MyTorrentsView.this.drag_drop_line_start = -1;
                            MyTorrentsView.access$1602(MyTorrentsView.this, null);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LOGID, "failed to init drag-n-drop", t));
        }
    }

    private void moveRowsTo(TableRowCore[] rows, int iNewPos) {
        if (rows == null || rows.length == 0) {
            return;
        }
        TableColumnCore sortColumn = this.tv.getSortColumn();
        boolean isSortAscending = sortColumn == null ? true : sortColumn.isSortAscending();
        for (int i = 0; i < rows.length; ++i) {
            TableRowCore row = rows[i];
            Object ds = row.getDataSource(true);
            if (!(ds instanceof DownloadManager)) continue;
            DownloadManager dm = (DownloadManager)ds;
            int iOldPos = dm.getPosition();
            this.globalManager.moveTo(dm, iNewPos);
            if (isSortAscending) {
                if (iOldPos <= iNewPos) continue;
                ++iNewPos;
                continue;
            }
            if (iOldPos >= iNewPos) continue;
            --iNewPos;
        }
        boolean bForceSort = sortColumn == null ? false : sortColumn.getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    @Override
    public void tableRefresh() {
        if (this.tv.isDisposed()) {
            return;
        }
        this.refreshTorrentMenu();
    }

    public void keyPressed(KeyEvent e) {
        this.viewActive = true;
        int key = e.character;
        if (key <= 26 && key > 0) {
            key += 96;
        }
        if (e.stateMask == 393216) {
            if (key == 115) {
                ManagerUtils.asyncStopAll();
                e.doit = false;
                return;
            }
            if (e.keyCode == 0x1000002) {
                this.moveSelectedTorrents(10);
                e.doit = false;
                return;
            }
            if (e.keyCode == 0x1000001) {
                this.moveSelectedTorrents(-10);
                e.doit = false;
                return;
            }
        }
        if (e.stateMask == SWT.MOD1) {
            switch (key) {
                case 97: {
                    if (e.widget == this.txtFilter) break;
                    this.tv.selectAll();
                    e.doit = false;
                    break;
                }
                case 99: {
                    if (e.widget == this.txtFilter) break;
                    this.tv.clipboardSelected();
                    e.doit = false;
                    break;
                }
                case 105: {
                    this.showSelectedDetails();
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
        }
        if (e.stateMask == 262144) {
            switch (e.keyCode) {
                case 0x1000001: {
                    this.moveSelectedTorrentsUp();
                    e.doit = false;
                    break;
                }
                case 0x1000002: {
                    this.moveSelectedTorrentsDown();
                    e.doit = false;
                    break;
                }
                case 0x1000007: {
                    this.moveSelectedTorrentsTop();
                    e.doit = false;
                    break;
                }
                case 0x1000008: {
                    this.moveSelectedTorrentsEnd();
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
            switch (key) {
                case 114: {
                    TorrentUtil.resumeTorrents(this.tv.getSelectedDataSources().toArray());
                    e.doit = false;
                    break;
                }
                case 115: {
                    Utils.getOffOfSWTThread(new AERunnable(){

                        public void runSupport() {
                            TorrentUtil.stopDataSources(MyTorrentsView.this.tv.getSelectedDataSources().toArray());
                        }
                    });
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
        }
        if (e.keyCode == 0x100000B && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
            FilesViewMenuUtil.rename(this.tv, null, this.tv.getSelectedDataSources(true), true, false);
            e.doit = false;
            return;
        }
        if (e.stateMask == 0 && e.keyCode == 127 && e.widget != this.txtFilter) {
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    TorrentUtil.removeDataSources(MyTorrentsView.this.tv.getSelectedDataSources().toArray());
                }
            });
            e.doit = false;
            return;
        }
        if (e.keyCode != 8 && ((e.stateMask & 0xFFFDFFFF) != 0 || e.character < ' ')) {
            return;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void moveSelectedTorrentsDown() {
        DownloadManager[] dms = this.getSelectedDownloads();
        Arrays.sort(dms, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager a, DownloadManager b) {
                return a.getPosition() - b.getPosition();
            }
        });
        for (int i = dms.length - 1; i >= 0; --i) {
            DownloadManager dm = dms[i];
            if (!dm.getGlobalManager().isMoveableDown(dm)) continue;
            dm.getGlobalManager().moveDown(dm);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrentsUp() {
        DownloadManager[] dms = this.getSelectedDownloads();
        Arrays.sort(dms, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager a, DownloadManager b) {
                return a.getPosition() - b.getPosition();
            }
        });
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            if (!dm.getGlobalManager().isMoveableUp(dm)) continue;
            dm.getGlobalManager().moveUp(dm);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrents(int by) {
        DownloadManager dm;
        int i;
        DownloadManager[] dms = this.getSelectedDownloads();
        if (dms.length <= 0) {
            return;
        }
        int[] newPositions = new int[dms.length];
        if (by < 0) {
            Arrays.sort(dms, new Comparator<DownloadManager>(){

                @Override
                public int compare(DownloadManager a, DownloadManager b) {
                    return a.getPosition() - b.getPosition();
                }
            });
        } else {
            Arrays.sort(dms, new Comparator<DownloadManager>(){

                @Override
                public int compare(DownloadManager a, DownloadManager b) {
                    return b.getPosition() - a.getPosition();
                }
            });
        }
        for (i = 0; i < dms.length; ++i) {
            dm = dms[i];
            boolean complete = dm.isDownloadComplete(false);
            int count = this.globalManager.downloadManagerCount(complete);
            int pos = dm.getPosition() + by;
            if (pos < i + 1) {
                pos = i + 1;
            } else if (pos > count - i) {
                pos = count - i;
            }
            newPositions[i] = pos;
        }
        for (i = 0; i < dms.length; ++i) {
            dm = dms[i];
            this.globalManager.moveTo(dm, newPositions[i]);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrentsTop() {
        this.moveSelectedTorrentsTopOrEnd(true);
    }

    private void moveSelectedTorrentsEnd() {
        this.moveSelectedTorrentsTopOrEnd(false);
    }

    private void moveSelectedTorrentsTopOrEnd(boolean moveToTop) {
        DownloadManager[] dms = this.getSelectedDownloads();
        if (dms.length == 0) {
            return;
        }
        if (moveToTop) {
            this.globalManager.moveTop(dms);
        } else {
            this.globalManager.moveEnd(dms);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        if (bForceSort) {
            this.tv.columnInvalidate("#");
            this.tv.refreshTable(bForceSort);
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (parameterName == null || parameterName.equals("DND Always In Incomplete")) {
            this.bDNDalwaysIncomplete = COConfigurationManager.getBooleanParameter("DND Always In Incomplete");
        }
        if (parameterName != null && (parameterName.equals("Library.ShowCatButtons") || parameterName.equals("Library.ShowTagButtons") || parameterName.equals("Library.ShowTagButtons.CompOnly"))) {
            this.createTabs();
        }
    }

    private MdiEntrySWT getActiveView() {
        TableViewSWT_TabsCommon tabsCommon = this.tv.getTabsCommon();
        if (tabsCommon != null) {
            return tabsCommon.getActiveSubView();
        }
        return null;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        UIPluginViewToolBarListener l;
        MdiEntrySWT active_view;
        ISelectedContent[] datasource = SelectedContentManager.getCurrentlySelectedContent();
        if (!this.isTableFocus() && (active_view = this.getActiveView()) != null && (l = active_view.getToolBarListener()) != null) {
            HashMap<String, Long> activeViewList = new HashMap<String, Long>();
            l.refreshToolBarItems(activeViewList);
            if (activeViewList.size() > 0) {
                list.putAll(activeViewList);
                return;
            }
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        boolean isTableSelected = false;
        if (this.tv instanceof TableViewImpl) {
            isTableSelected = ((TableViewImpl)((Object)this.tv)).isTableSelected();
        }
        if (!isTableSelected) {
            UIPluginViewToolBarListener l;
            MdiEntrySWT active_view = this.getActiveView();
            return active_view != null && (l = active_view.getToolBarListener()) != null && l.toolBarItemActivated(item, activationType, datasource);
        }
        String itemKey = item.getID();
        if (activationType == 1L) {
            if (itemKey.equals("up")) {
                this.moveSelectedTorrentsTop();
                return true;
            }
            if (itemKey.equals("down")) {
                this.moveSelectedTorrentsEnd();
                return true;
            }
            return false;
        }
        if (activationType != 0L) {
            return false;
        }
        if (itemKey.equals("top")) {
            this.moveSelectedTorrentsTop();
            return true;
        }
        if (itemKey.equals("bottom")) {
            this.moveSelectedTorrentsEnd();
            return true;
        }
        if (itemKey.equals("up")) {
            this.moveSelectedTorrentsUp();
            return true;
        }
        if (itemKey.equals("down")) {
            this.moveSelectedTorrentsDown();
            return true;
        }
        if (itemKey.equals("run")) {
            TorrentUtil.runDataSources(this.tv.getSelectedDataSources().toArray());
            return true;
        }
        if (itemKey.equals("start")) {
            TorrentUtil.queueDataSources(this.tv.getSelectedDataSources().toArray(), true);
            return true;
        }
        if (itemKey.equals("stop")) {
            TorrentUtil.stopDataSources(this.tv.getSelectedDataSources().toArray());
            return true;
        }
        if (itemKey.equals("startstop")) {
            TorrentUtil.stopOrStartDataSources(this.tv.getSelectedDataSources().toArray());
            return true;
        }
        if (itemKey.equals("remove")) {
            TorrentUtil.removeDataSources(this.tv.getSelectedDataSources().toArray());
            return true;
        }
        return false;
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
        final TableRowCore row = this.tv.getRow(manager);
        if (row != null) {
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    row.refresh(true);
                    if (row.isSelected()) {
                        MyTorrentsView.this.updateSelectedContentRateLimited();
                    }
                }
            });
        }
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        if (this.isOurDownloadManager(download)) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    MyTorrentsView.this.updateSelectedContent();
                }
            });
        }
    }

    @Override
    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
        if (this.isOurDownloadManager(manager)) {
            this.tv.addDataSource(manager);
        } else {
            this.tv.removeDataSource(manager);
        }
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
    }

    @Override
    public void tagAdded(Tag tag) {
        this.createTabs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tagChanged(Tag tag) {
        Set<Tag> set = this.pending_tag_changes;
        synchronized (set) {
            this.pending_tag_changes.add(tag);
        }
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (MyTorrentsView.this.allTags != null) {
                    boolean create_tabs = false;
                    Set set = MyTorrentsView.this.pending_tag_changes;
                    synchronized (set) {
                        for (Tag t : MyTorrentsView.this.pending_tag_changes) {
                            boolean is_visible;
                            boolean should_be_visible = t.isVisible();
                            if (should_be_visible == (is_visible = MyTorrentsView.this.allTags.contains(t))) continue;
                            create_tabs = true;
                            break;
                        }
                        MyTorrentsView.this.pending_tag_changes.clear();
                    }
                    if (create_tabs) {
                        MyTorrentsView.this.createTabs();
                    }
                }
            }
        });
    }

    @Override
    public void tagRemoved(Tag tag) {
        if (this.currentTags == null) {
            return;
        }
        this.removeTagFromCurrent(tag);
        this.createTabs();
    }

    private void removeTagFromCurrent(Tag tag) {
        boolean found = false;
        for (int i = 0; i < this.currentTags.length; ++i) {
            Tag[] tags;
            Tag curTag = this.currentTags[i];
            if (!curTag.equals(tag)) continue;
            if (this.currentTags.length == 1) {
                tags = new Tag[]{CategoryManager.getCategory(1)};
            } else {
                tags = new Tag[this.currentTags.length - 1];
                if (i > 0) {
                    System.arraycopy(this.currentTags, 0, tags, 0, i);
                }
                if (tags.length - i > 0) {
                    System.arraycopy(this.currentTags, i + 1, tags, 0, tags.length - i);
                }
            }
            this.setCurrentTags(tags);
            found = true;
            break;
        }
        if (!found) {
            this.setCurrentTags(this.currentTags);
        }
    }

    private Object[] removeFromArray(Object[] array, Object o) {
        for (int i = 0; i < array.length; ++i) {
            Object cur = array[i];
            if (!cur.equals(o)) continue;
            Object[] newArray = new Tag[array.length - 1];
            if (i > 0) {
                System.arraycopy(array, 0, newArray, 0, i);
            }
            if (newArray.length - i > 0) {
                System.arraycopy(array, i + 1, newArray, 0, newArray.length - i);
            }
            return newArray;
        }
        return array;
    }

    private void setCurrentTags(Tag[] tags) {
        if (this.currentTags != null) {
            for (Tag tag : this.currentTags) {
                tag.removeTagListener(this);
            }
        }
        this.currentTags = tags;
        if (this.currentTags != null) {
            HashSet<Tag> to_remove = null;
            for (Tag tag : this.currentTags) {
                if (tag.getTaggableTypes() != 2) {
                    if (to_remove == null) {
                        to_remove = new HashSet<Tag>();
                    }
                    to_remove.add(tag);
                    continue;
                }
                tag.addTagListener(this, false);
            }
            if (to_remove != null) {
                Tag[] updated_tags = new Tag[this.currentTags.length - to_remove.size()];
                int pos = 0;
                for (Tag tag : this.currentTags) {
                    if (to_remove.contains(tag)) continue;
                    updated_tags[pos++] = tag;
                }
                this.currentTags = updated_tags;
            }
        }
        this.tv.processDataSourceQueue();
        Object[] managers = this.globalManager.getDownloadManagers().toArray();
        ArrayList<DownloadManager> listRemoves = new ArrayList<DownloadManager>();
        ArrayList<DownloadManager> listAdds = new ArrayList<DownloadManager>();
        for (int i = 0; i < managers.length; ++i) {
            DownloadManager dm = (DownloadManager)managers[i];
            boolean bHave = this.tv.isUnfilteredDataSourceAdded(dm);
            if (!this.isOurDownloadManager(dm)) {
                if (!bHave) continue;
                listRemoves.add(dm);
                continue;
            }
            if (bHave) continue;
            listAdds.add(dm);
        }
        this.tv.removeDataSources((DownloadManager[])listRemoves.toArray(new DownloadManager[0]));
        this.tv.addDataSources((DownloadManager[])listAdds.toArray(new DownloadManager[0]));
        this.tv.processDataSourceQueue();
    }

    private boolean isInTags(DownloadManager manager, Tag[] tags) {
        if (tags == null) {
            return true;
        }
        for (Tag tag : tags) {
            if (!tag.hasTaggable(manager)) continue;
            return true;
        }
        return false;
    }

    public boolean isInCurrentTag(DownloadManager manager) {
        return this.isInTags(manager, this.currentTags);
    }

    @Override
    public void taggableAdded(Tag tag, Taggable tagged) {
        DownloadManager manager = (DownloadManager)tagged;
        if (this.isOurDownloadManager(manager)) {
            this.tv.addDataSource(manager);
        }
    }

    @Override
    public void taggableSync(Tag tag) {
        List dataSources = this.tv.getDataSources();
        for (DownloadManager dm : dataSources) {
            if (this.isOurDownloadManager(dm)) continue;
            this.tv.removeDataSource(dm);
        }
        for (Taggable t : tag.getTagged()) {
            DownloadManager manager = (DownloadManager)t;
            if (!this.isOurDownloadManager(manager) || this.tv.dataSourceExists(manager)) continue;
            this.tv.addDataSource(manager);
        }
    }

    @Override
    public void taggableRemoved(Tag tag, Taggable tagged) {
        DownloadManager manager = (DownloadManager)tagged;
        this.tv.removeDataSource(manager);
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
        dm.addListener(this);
        if (this.isOurDownloadManager(dm)) {
            this.tv.addDataSource(dm);
        }
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removeListener(this);
        DownloadBar.close(dm);
        this.tv.removeDataSource(dm);
    }

    @Override
    public void destroyInitiated() {
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        this.getComposite().layout(true, true);
    }

    public boolean isTableFocus() {
        return this.viewActive;
    }

    public Image obfusticatedImage(Image image) {
        return this.tv.obfusticatedImage(image);
    }

    protected TableViewSWT<DownloadManager> createTableView(Class<?> forDataSourceType, String tableID, TableColumnCore[] basicItems) {
        String pluginInfo;
        int tableExtraStyle = COConfigurationManager.getIntParameter("MyTorrentsView.table.style");
        TableViewSWT<DownloadManager> table = TableViewFactory.createTableViewSWT(forDataSourceType, tableID, this.getPropertiesPrefix(), basicItems, "#", tableExtraStyle | 2 | 0x10000 | 0x10000000 | 0x40);
        boolean enable_tab_views = !Utils.isAZ2UI() && this.supportsTabs && COConfigurationManager.getBooleanParameter("Library.ShowTabsInTorrentView");
        ArrayList<String> restrictTo = new ArrayList<String>();
        restrictTo.addAll(Arrays.asList("GeneralView", "TrackerView", "PeersView", PeersGraphicView.MSGID_PREFIX, "PiecesView", "DownloadActivityView", "PieceInfoView", "FilesView", "TaggingView", "PrivacyView"));
        restrictTo.add("azbuddy.ui.menu.chat");
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("aercm", true);
        if (pi != null && (pluginInfo = pi.getPluginconfig().getPluginStringParameter("plugin.info", "")).equals("e")) {
            restrictTo.add("rcm.subview.torrentdetails.name");
        }
        if (Logger.isEnabled()) {
            restrictTo.add("ConsoleView");
        }
        table.setEnableTabViews(enable_tab_views, false, restrictTo.toArray(new String[0]));
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            UISWTInstance pluginUI = uiFunctions.getUISWTInstance();
            MyTorrentsView.registerPluginViews(pluginUI);
        }
        return table;
    }

    public static void registerPluginViews(UISWTInstance pluginUI) {
        if (pluginUI != null && !registeredCoreSubViews) {
            String[] views_with_tabs = new String[]{"MyLibrary.big", "MyTorrents", "MyTorrents.big", "MySeeders"};
            boolean hasTags = false;
            try {
                hasTags = TagManagerFactory.getTagManager().getTagType(3).getTags().size() > 0;
            }
            catch (Throwable t) {
                // empty catch block
            }
            for (String id : views_with_tabs) {
                pluginUI.addView(id, "GeneralView", GeneralView.class, null);
                pluginUI.addView(id, "TrackerView", TrackerView.class, null);
                pluginUI.addView(id, "PeersView", PeersView.class, null);
                pluginUI.addView(id, PeersGraphicView.MSGID_PREFIX, PeersGraphicView.class, null);
                pluginUI.addView(id, "PiecesView", PiecesView.class, null);
                pluginUI.addView(id, "PieceInfoView", PieceInfoView.class, null);
                pluginUI.addView(id, "DownloadActivityView", DownloadActivityView.class, null);
                pluginUI.addView(id, "FilesView", FilesView.class, null);
                pluginUI.addView(id, "TorrentInfoView", TorrentInfoView.class, null);
                pluginUI.addView(id, "TorrentOptionsView", TorrentOptionsView.class, null);
                if (hasTags) {
                    pluginUI.addView(id, "TaggingView", TaggingView.class, null);
                }
                pluginUI.addView(id, "PrivacyView", PrivacyView.class, null);
                if (!Logger.isEnabled()) continue;
                pluginUI.addView(id, "ConsoleView", LoggerView.class, null);
            }
            registeredCoreSubViews = true;
        }
    }

    protected int getRowDefaultHeight() {
        return -1;
    }

    @Override
    public void rowRefresh(TableRow row) {
        DiskManagerFileInfoSet fileInfos;
        if (!(row instanceof TableRowCore)) {
            return;
        }
        TableRowCore rowCore = (TableRowCore)row;
        Object ds = rowCore.getDataSource(true);
        if (!(ds instanceof DownloadManager)) {
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (rowCore.getSubItemCount() == 0 && dm.getTorrent() != null && !dm.getTorrent().isSimpleTorrent() && rowCore.isVisible() && dm.getNumFileInfos() > 0 && (fileInfos = dm.getDiskManagerFileInfoSet()) != null) {
            Object[] files = fileInfos.getFiles();
            boolean copied = false;
            int pos = 0;
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo fileInfo2 = files[i];
                if (fileInfo2.isSkipped() && (fileInfo2.getStorageType() == 2 || fileInfo2.getStorageType() == 4)) continue;
                if (pos != i) {
                    if (!copied) {
                        Object[] oldFiles = files;
                        files = new DiskManagerFileInfo[files.length];
                        System.arraycopy(oldFiles, 0, files, 0, files.length);
                        copied = true;
                    }
                    files[pos] = files[i];
                }
                ++pos;
            }
            if (pos != files.length) {
                Object[] oldFiles = files;
                files = new DiskManagerFileInfo[pos];
                System.arraycopy(oldFiles, 0, files, 0, pos);
            }
            rowCore.setSubItems(files);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        boolean b = super.eventOccurred(event2);
        if (event2.getType() == 3) {
            if (this.rebuildListOnFocusGain) {
                List<DownloadManager> dms = this.globalManager.getDownloadManagers();
                ArrayList<DownloadManager> listAdds = new ArrayList<DownloadManager>();
                ArrayList<DownloadManager> listRemoves = new ArrayList<DownloadManager>();
                for (DownloadManager dm : dms) {
                    if (!this.isOurDownloadManager(dm)) {
                        listRemoves.add(dm);
                        continue;
                    }
                    listAdds.add(dm);
                }
                this.tv.removeDataSources((DownloadManager[])listRemoves.toArray(new DownloadManager[0]));
                this.tv.addDataSources((DownloadManager[])listAdds.toArray(new DownloadManager[0]));
            }
            this.updateSelectedContent(true);
        } else if (event2.getType() == 4) {
            // empty if block
        }
        return b;
    }

    public void setRebuildListOnFocusGain(boolean rebuildListOnFocusGain) {
        this.rebuildListOnFocusGain = rebuildListOnFocusGain;
    }

    @Override
    public void rowAdded(TableRowCore row) {
        DownloadManager dm;
        if (row.getParentRowCore() == null && (dm = (DownloadManager)row.getDataSource(true)).getDownloadState().getBooleanAttribute("file.expand")) {
            row.setExpanded(true);
        }
    }

    @Override
    public void rowRemoved(TableRowCore row) {
    }

    @Override
    public void rowExpanded(TableRowCore row) {
        if (row.getParentRowCore() == null) {
            DownloadManager dm = (DownloadManager)row.getDataSource(true);
            dm.getDownloadState().setBooleanAttribute("file.expand", true);
        }
    }

    @Override
    public void rowCollapsed(TableRowCore row) {
        if (row.getParentRowCore() == null) {
            DownloadManager dm = (DownloadManager)row.getDataSource(true);
            dm.getDownloadState().setBooleanAttribute("file.expand", false);
        }
    }

    protected Class<?> getForDataSourceType() {
        return this.forDataSourceType;
    }

    private boolean isCurrent(Tag tag) {
        if (this.currentTags != null) {
            for (Tag curTag : this.currentTags) {
                if (!tag.equals(curTag)) continue;
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ TableRowCore[] access$1602(MyTorrentsView x0, TableRowCore[] x1) {
        x0.drag_drop_rows = x1;
        return x1;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"mtv.trackername.pref.hosts", "mtv.eta.show_absolute", "mtv.progress_eta.show_absolute"}, new ParameterListener(){

            public void parameterChanged(String name) {
                String prefs = COConfigurationManager.getStringParameter("mtv.trackername.pref.hosts", null);
                HashSet<String> new_vals = new HashSet<String>();
                if (prefs != null) {
                    String[] bits;
                    for (String s : bits = prefs.split(";")) {
                        if ((s = s.trim()).length() <= 0) continue;
                        new_vals.add(s);
                    }
                }
                preferred_tracker_names = new_vals;
                eta_absolute = COConfigurationManager.getBooleanParameter("mtv.eta.show_absolute", false);
                progress_eta_absolute = COConfigurationManager.getBooleanParameter("mtv.progress_eta.show_absolute", false);
            }
        });
        registeredCoreSubViews = false;
    }
}

