/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.io.File;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.ColorParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericBooleanParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericFloatParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericIntParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class TagSettingsView
implements UISWTViewCoreEventListener,
TagTypeListener {
    private UISWTView swtView;
    private Composite cMainComposite;
    private ScrolledComposite sc;
    private Tag tag;
    private Params params = null;

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        this.dataSourceChanged(null);
        this.params = null;
    }

    private void refresh() {
    }

    private void dataSourceChanged(Object ds) {
        Object[] objects;
        TagType tagType;
        if (this.tag != null) {
            tagType = this.tag.getTagType();
            tagType.removeTagTypeListener(this);
        }
        this.tag = ds instanceof Tag ? (Tag)ds : (ds instanceof Object[] ? ((objects = (Object[])ds).length == 1 && objects[0] instanceof Tag ? (Tag)objects[0] : null) : null);
        if (this.tag != null) {
            tagType = this.tag.getTagType();
            tagType.addTagTypeListener(this, true);
        }
        this.initialize(null);
    }

    private void initialize(final Composite parent) {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                TagSettingsView.this.swt_initialize(parent);
            }
        });
    }

    private void swt_initialize(Composite parent) {
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            if (parent == null || parent.isDisposed()) {
                return;
            }
            this.sc = new ScrolledComposite(parent, 512);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.getVerticalBar().setIncrement(16);
            Layout parentLayout = parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                GridData gd = new GridData(4, 4, true, true);
                this.sc.setLayoutData((Object)gd);
            } else if (parentLayout instanceof FormLayout) {
                this.sc.setLayoutData((Object)Utils.getFilledFormData());
            }
            this.cMainComposite = new Composite((Composite)this.sc, 0);
            this.sc.setContent((Control)this.cMainComposite);
        } else {
            Utils.disposeComposite(this.cMainComposite, false);
        }
        if (this.tag == null) {
            this.params = null;
            this.cMainComposite.setLayout((Layout)new FillLayout());
            Label label = new Label(this.cMainComposite, 0);
            label.setText("Select one tag to see the tag's settings");
        } else {
            TagFeatureProperties tfp;
            TagFeatureProperties.TagProperty propConstraint;
            TagFeatureFileLocation fl;
            this.params = new Params();
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            this.cMainComposite.setLayout((Layout)gridLayout);
            Composite cSection1 = new Composite(this.cMainComposite, 0);
            gridLayout = new GridLayout(4, false);
            gridLayout.marginHeight = 0;
            cSection1.setLayout((Layout)gridLayout);
            GridData gd = new GridData(4, 4, true, false);
            cSection1.setLayoutData((Object)gd);
            Composite cSection2 = new Composite(this.cMainComposite, 0);
            gridLayout = new GridLayout(4, false);
            cSection2.setLayout((Layout)gridLayout);
            gd = new GridData(4, 4, true, false);
            cSection2.setLayoutData((Object)gd);
            Label label = new Label(cSection1, 0);
            label.setText(this.tag.getTagType().getTagTypeName(true));
            FontUtils.setFontHeight((Control)label, 12, 1);
            gd = new GridData();
            gd.horizontalSpan = 4;
            label.setLayoutData((Object)gd);
            label = new Label(cSection1, 0);
            Messages.setLanguageText((Widget)label, "MinimizedWindow.name");
            gd = new GridData(1, 0x1000000, false, false);
            label.setLayoutData((Object)gd);
            if (!this.tag.getTagType().isTagTypeAuto()) {
                Text txtName = new Text(cSection1, 2048);
                this.params.cName = (Control)txtName;
                gd = new GridData(4, 0x1000000, true, false);
                txtName.setLayoutData((Object)gd);
                txtName.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        try {
                            String newName = ((Text)e.widget).getText();
                            if (!TagSettingsView.this.tag.getTagName(true).equals(newName)) {
                                TagSettingsView.this.tag.setTagName(newName);
                            }
                        }
                        catch (TagException e1) {
                            Debug.out(e1);
                        }
                    }
                });
            } else {
                label = new Label(cSection1, 0);
                gd = new GridData(4, 0x1000000, true, false);
                label.setLayoutData((Object)gd);
                this.params.cName = (Control)label;
            }
            label = new Label(cSection1, 0);
            Messages.setLanguageText((Widget)label, "label.color");
            int[] color = this.tag.getColor();
            this.params.tagColor = new ColorParameter(cSection1, null, color[0], color[1], color[2]){

                public void newColorChosen(RGB newColor) {
                    TagSettingsView.this.tag.setColor(new int[]{newColor.red, newColor.green, newColor.blue});
                }
            };
            this.params.viewInSideBar = new GenericBooleanParameter(new GenericParameterAdapter(){

                public boolean getBooleanValue(String key) {
                    return TagSettingsView.this.tag.isVisible();
                }

                public boolean getBooleanValue(String key, boolean def) {
                    return TagSettingsView.this.tag.isVisible();
                }

                public void setBooleanValue(String key, boolean value) {
                    TagSettingsView.this.tag.setVisible(value);
                }
            }, cSection2, null, "TagSettings.viewInSideBar");
            gd = new GridData();
            gd.horizontalSpan = 4;
            this.params.viewInSideBar.setLayoutData(gd);
            if (this.tag.canBePublic()) {
                this.params.isPublic = new GenericBooleanParameter(new GenericParameterAdapter(){

                    public boolean getBooleanValue(String key) {
                        return TagSettingsView.this.tag.isPublic();
                    }

                    public boolean getBooleanValue(String key, boolean def) {
                        return TagSettingsView.this.tag.isPublic();
                    }

                    public void setBooleanValue(String key, boolean value) {
                        TagSettingsView.this.tag.setPublic(value);
                    }
                }, cSection2, null, "TagAddWindow.public.checkbox");
                gd = new GridData();
                gd.horizontalSpan = 4;
                this.params.isPublic.setLayoutData(gd);
            }
            Group gTransfer = new Group(this.cMainComposite, 0);
            gTransfer.setText("Transfer Settings");
            gridLayout = new GridLayout(4, false);
            gTransfer.setLayout((Layout)gridLayout);
            gd = new GridData(0, 0, false, false, 4, 1);
            gTransfer.setLayoutData((Object)gd);
            if (this.tag instanceof TagFeatureRateLimit) {
                final TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)this.tag);
                String k_unit = DisplayFormatters.getRateUnitBase10(1).trim();
                if (rl.supportsTagDownloadLimit() && rl.supportsTagDownloadLimit()) {
                    gd = new GridData();
                    label = new Label((Composite)gTransfer, 0);
                    label.setLayoutData((Object)gd);
                    label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxdownloadspeed.tooltip"));
                    gd = new GridData();
                    this.params.maxDownloadSpeed = new GenericIntParameter(new GenericParameterAdapter(){

                        public int getIntValue(String key) {
                            int limit = rl.getTagDownloadLimit();
                            return limit < 0 ? limit : limit / 1024;
                        }

                        public int getIntValue(String key, int def) {
                            return this.getIntValue(key);
                        }

                        public void setIntValue(String key, int value) {
                            if (value == -1) {
                                rl.setTagDownloadLimit(-1);
                            } else {
                                rl.setTagDownloadLimit(value * 1024);
                            }
                        }

                        public boolean resetIntDefault(String key) {
                            return false;
                        }
                    }, (Composite)gTransfer, null, -1, Integer.MAX_VALUE);
                    this.params.maxDownloadSpeed.setLayoutData(gd);
                }
                if (rl.supportsTagUploadLimit()) {
                    gd = new GridData();
                    label = new Label((Composite)gTransfer, 0);
                    label.setLayoutData((Object)gd);
                    label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxuploadspeed.tooltip"));
                    gd = new GridData();
                    this.params.maxUploadSpeed = new GenericIntParameter(new GenericParameterAdapter(){

                        public int getIntValue(String key) {
                            int limit = rl.getTagUploadLimit();
                            return limit < 0 ? limit : limit / 1024;
                        }

                        public int getIntValue(String key, int def) {
                            return this.getIntValue(key);
                        }

                        public void setIntValue(String key, int value) {
                            if (value == -1) {
                                rl.setTagUploadLimit(value);
                            } else {
                                rl.setTagUploadLimit(value * 1024);
                            }
                        }

                        public boolean resetIntDefault(String key) {
                            return false;
                        }
                    }, (Composite)gTransfer, null, -1, Integer.MAX_VALUE);
                    this.params.maxUploadSpeed.setLayoutData(gd);
                }
                if (rl.getTagUploadPriority() >= 0) {
                    this.params.uploadPriority = new GenericBooleanParameter(new GenericParameterAdapter(){

                        public boolean getBooleanValue(String key) {
                            return rl.getTagUploadPriority() > 0;
                        }

                        public boolean getBooleanValue(String key, boolean def) {
                            return this.getBooleanValue(key);
                        }

                        public void setBooleanValue(String key, boolean value) {
                            rl.setTagUploadPriority(value ? 1 : 0);
                        }
                    }, (Composite)gTransfer, null, "cat.upload.priority");
                    gd = new GridData();
                    gd.horizontalSpan = 4;
                    this.params.uploadPriority.setLayoutData(gd);
                }
                if (rl.getTagMinShareRatio() >= 0) {
                    label = new Label((Composite)gTransfer, 0);
                    Messages.setLanguageText((Widget)label, "TableColumn.header.min_sr");
                    gd = new GridData(1, 0x1000000, false, false);
                    label.setLayoutData((Object)gd);
                    this.params.min_sr = new GenericFloatParameter(new GenericParameterAdapter(){

                        public float getFloatValue(String key) {
                            return (float)rl.getTagMinShareRatio() / 1000.0f;
                        }

                        public void setFloatValue(String key, float value) {
                            rl.setTagMinShareRatio((int)(value * 1000.0f));
                        }
                    }, (Composite)gTransfer, null, 0.0f, Float.MAX_VALUE, true, 3);
                    gd = new GridData();
                    gd.widthHint = 50;
                    this.params.min_sr.setLayoutData(gd);
                }
                if (rl.getTagMaxShareRatio() >= 0) {
                    label = new Label((Composite)gTransfer, 0);
                    Messages.setLanguageText((Widget)label, "TableColumn.header.max_sr");
                    gd = new GridData(1, 0x1000000, false, false);
                    label.setLayoutData((Object)gd);
                    this.params.max_sr = new GenericFloatParameter(new GenericParameterAdapter(){

                        public float getFloatValue(String key) {
                            return (float)rl.getTagMaxShareRatio() / 1000.0f;
                        }

                        public void setFloatValue(String key, float value) {
                            rl.setTagMaxShareRatio((int)(value * 1000.0f));
                        }
                    }, (Composite)gTransfer, null, 0.0f, Float.MAX_VALUE, true, 3);
                    gd = new GridData();
                    gd.widthHint = 50;
                    this.params.max_sr.setLayoutData(gd);
                }
            }
            if (this.tag instanceof TagFeatureFileLocation && ((fl = (TagFeatureFileLocation)((Object)this.tag)).supportsTagCopyOnComplete() || fl.supportsTagInitialSaveFolder() || fl.supportsTagMoveOnComplete())) {
                Group gFiles = new Group(this.cMainComposite, 0);
                gFiles.setText("File Settings");
                gridLayout = new GridLayout(4, false);
                gFiles.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, true, false, 4, 1);
                gFiles.setLayoutData((Object)gd);
                if (fl.supportsTagInitialSaveFolder()) {
                    this.params.initalSaveFolder = new folderOption((Composite)gFiles, "label.init.save.loc"){

                        public void setFolder(File folder) {
                            fl.setTagInitialSaveFolder(folder);
                        }

                        public File getFolder() {
                            return fl.getTagInitialSaveFolder();
                        }
                    };
                }
                if (fl.supportsTagMoveOnComplete()) {
                    this.params.moveOnCompleteFolder = new folderOption((Composite)gFiles, "label.move.on.comp"){

                        public void setFolder(File folder) {
                            fl.setTagMoveOnCompleteFolder(folder);
                        }

                        public File getFolder() {
                            return fl.getTagMoveOnCompleteFolder();
                        }
                    };
                }
                if (fl.supportsTagCopyOnComplete()) {
                    this.params.copyOnCompleteFolder = new folderOption((Composite)gFiles, "label.copy.on.comp"){

                        public void setFolder(File folder) {
                            fl.setTagCopyOnCompleteFolder(folder);
                        }

                        public File getFolder() {
                            return fl.getTagCopyOnCompleteFolder();
                        }
                    };
                }
            }
            if (this.tag.getTagType().hasTagTypeFeature(32L) && this.tag instanceof TagFeatureProperties && (propConstraint = (tfp = (TagFeatureProperties)((Object)this.tag)).getProperty("constraint")) != null) {
                Group gConstraint = new Group(this.cMainComposite, 0);
                Messages.setLanguageText((Widget)gConstraint, "tag.property.constraint");
                gridLayout = new GridLayout(3, false);
                gConstraint.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, true, false, 4, 1);
                gConstraint.setLayoutData((Object)gd);
                this.params.constraints = new Text((Composite)gConstraint, 2114);
                gd = new GridData(4, 0, true, false, 3, 1);
                gd.heightHint = 40;
                this.params.constraints.setLayoutData((Object)gd);
                this.params.constraints.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        ((TagSettingsView)TagSettingsView.this).params.constraints.setData("skipset", (Object)1);
                    }
                });
                Button btnSave = new Button((Composite)gConstraint, 8);
                btnSave.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        propConstraint.setStringList(new String[]{((TagSettingsView)TagSettingsView.this).params.constraints.getText()});
                    }
                });
                Messages.setLanguageText((Widget)btnSave, "Button.save");
                Button btnReset = new Button((Composite)gConstraint, 8);
                btnReset.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        ((TagSettingsView)TagSettingsView.this).params.constraints.setData("skipset", null);
                        TagSettingsView.this.swt_updateFields();
                    }
                });
                Messages.setLanguageText((Widget)btnReset, "Button.reset");
                Link lblAboutConstraint = new Link((Composite)gConstraint, 64);
                lblAboutConstraint.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 512));
                lblAboutConstraint.setText(MessageText.getString("tag.constraints.info"));
                lblAboutConstraint.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        if (event2.text != null && (event2.text.startsWith("http://") || event2.text.startsWith("https://"))) {
                            Utils.launch(event2.text);
                        }
                    }
                });
            }
            this.swt_updateFields();
        }
        this.cMainComposite.layout();
        this.sc.setMinSize(this.cMainComposite.computeSize(-1, -1));
    }

    private String getFullTitle() {
        return MessageText.getString("TagSettingsView.title");
    }

    private void swt_updateFields() {
        if (this.tag == null || this.params == null) {
            this.initialize(null);
            return;
        }
        if (this.params.cName != null && !this.params.cName.isDisposed()) {
            String name = this.tag.getTagName(true);
            if (this.params.cName instanceof Text) {
                Text txt = (Text)this.params.cName;
                if (!txt.getText().equals(name)) {
                    txt.setText(name);
                }
            } else if (this.params.cName instanceof Label) {
                Label lbl = (Label)this.params.cName;
                lbl.setText(name);
            }
        }
        if (this.params.tagColor != null) {
            int[] color = this.tag.getColor();
            this.params.tagColor.setColor(color[0], color[1], color[2]);
        }
        if (this.params.viewInSideBar != null) {
            this.params.viewInSideBar.refresh();
        }
        if (this.params.isPublic != null) {
            this.params.isPublic.refresh();
        }
        if (this.params.maxDownloadSpeed != null) {
            this.params.maxDownloadSpeed.resetToDefault();
        }
        if (this.params.maxUploadSpeed != null) {
            this.params.maxUploadSpeed.resetToDefault();
        }
        if (this.params.uploadPriority != null) {
            this.params.uploadPriority.refresh();
        }
        if (this.params.min_sr != null) {
            this.params.min_sr.refresh();
        }
        if (this.params.max_sr != null) {
            this.params.max_sr.refresh();
        }
        if (this.params.initalSaveFolder != null) {
            this.params.initalSaveFolder.update();
        }
        if (this.params.moveOnCompleteFolder != null) {
            this.params.moveOnCompleteFolder.update();
        }
        if (this.params.copyOnCompleteFolder != null) {
            this.params.copyOnCompleteFolder.update();
        }
        if (this.params.constraints != null && this.params.constraints.getData("skipset") == null) {
            String[] stringList;
            TagFeatureProperties tfp;
            TagFeatureProperties.TagProperty propConstraint;
            String text = "";
            if (this.tag.getTagType().hasTagTypeFeature(32L) && this.tag instanceof TagFeatureProperties && (propConstraint = (tfp = (TagFeatureProperties)((Object)this.tag)).getProperty("constraint")) != null && (stringList = propConstraint.getStringList()).length == 1 && stringList.length > 0) {
                text = stringList[0];
            }
            this.params.constraints.setText(text);
        }
    }

    public void tagTypeChanged(TagType tag_type) {
    }

    public void tagAdded(Tag tag) {
    }

    public void tagChanged(final Tag changedTag) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (changedTag.equals(TagSettingsView.this.tag)) {
                    TagSettingsView.this.swt_updateFields();
                }
            }
        });
    }

    public void tagRemoved(Tag tag) {
    }

    public static class Params {
        private Control cName;
        private ColorParameter tagColor;
        private GenericIntParameter maxDownloadSpeed;
        private GenericIntParameter maxUploadSpeed;
        private GenericBooleanParameter viewInSideBar;
        private GenericBooleanParameter isPublic;
        public GenericBooleanParameter uploadPriority;
        public GenericFloatParameter min_sr;
        public GenericFloatParameter max_sr;
        public folderOption initalSaveFolder;
        public folderOption moveOnCompleteFolder;
        public folderOption copyOnCompleteFolder;
        public Text constraints;
    }

    private static abstract class folderOption {
        private Button btnClear;
        private Label lblValue;

        public folderOption(final Composite parent, String labelTextID) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            Image imgOpenFolder = imageLoader.getImage("openFolderButton");
            GridData gd = new GridData();
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)gd);
            Messages.setLanguageText((Widget)label, labelTextID);
            Button browse = new Button(parent, 8);
            browse.setImage(imgOpenFolder);
            imgOpenFolder.setBackground(browse.getBackground());
            browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
            browse.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                    File tagInitialSaveFolder = folderOption.this.getFolder();
                    String filterPath = tagInitialSaveFolder != null ? tagInitialSaveFolder.toString() : COConfigurationManager.getStringParameter("Default save path");
                    dialog.setFilterPath(filterPath);
                    dialog.setMessage(MessageText.getString("label.init.save.loc"));
                    dialog.setText(MessageText.getString("label.init.save.loc"));
                    final String path = dialog.open();
                    if (path != null) {
                        Utils.getOffOfSWTThread(new AERunnable(){

                            public void runSupport() {
                                folderOption.this.setFolder(new File(path));
                            }
                        });
                    }
                }
            });
            this.lblValue = new Label(parent, 64);
            gd = Utils.getWrappableLabelGridData(1, 768);
            gd.verticalAlignment = 0x1000000;
            this.lblValue.setLayoutData((Object)gd);
            this.btnClear = new Button(parent, 8);
            Messages.setLanguageText((Widget)this.btnClear, "Button.clear");
            this.btnClear.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    folderOption.this.setFolder(null);
                }
            });
        }

        public void update() {
            File folder = this.getFolder();
            if (folder == null) {
                Messages.setLanguageText((Widget)this.lblValue, "label.none.assigned");
            } else {
                this.lblValue.setText(folder.toString());
            }
            this.btnClear.setVisible(folder != null);
        }

        public abstract File getFolder();

        public abstract void setFolder(File var1);
    }
}

