/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerTPSListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.views.ScrapeInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableSelectedRowsListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.CompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.IntervalItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.LastUpdateItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.LeechersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.PeersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.SeedsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.TypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.UpdateInItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerView
extends TableViewTab<TrackerPeerSource>
implements TableLifeCycleListener,
TableDataSourceChangedListener,
DownloadManagerTPSListener,
TableViewSWTMenuFillListener {
    private static boolean registeredCoreSubViews = false;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new TypeItem("Trackers"), new NameItem("Trackers"), new StatusItem("Trackers"), new PeersItem("Trackers"), new SeedsItem("Trackers"), new LeechersItem("Trackers"), new CompletedItem("Trackers"), new UpdateInItem("Trackers"), new IntervalItem("Trackers"), new LastUpdateItem("Trackers")};
    public static final String MSGID_PREFIX = "TrackerView";
    private DownloadManager manager;
    private boolean enable_tabs = true;
    private TableViewSWT<TrackerPeerSource> tv;

    public TrackerView() {
        super(MSGID_PREFIX);
    }

    @Override
    public TableViewSWT<TrackerPeerSource> initYourTableView() {
        UISWTInstance pluginUI;
        this.tv = TableViewFactory.createTableViewSWT(TrackerPeerSource.class, "Trackers", this.getPropertiesPrefix(), basicItems, basicItems[0].getName(), 0x10010002);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.setEnableTabViews(this.enable_tabs, true, null);
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null && !registeredCoreSubViews) {
            pluginUI.addView("Trackers", "ScrapeInfoView", ScrapeInfoView.class, this.manager);
            registeredCoreSubViews = true;
        }
        return this.tv;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        final Object[] sources = this.tv.getSelectedDataSources().toArray();
        boolean found_tracker = false;
        boolean found_dht_tracker = false;
        boolean update_ok = false;
        boolean delete_ok = false;
        for (Object o : sources) {
            int state;
            TrackerPeerSource ps = (TrackerPeerSource)o;
            if (ps.getType() == 1) {
                found_tracker = true;
            }
            if (ps.getType() == 3) {
                found_dht_tracker = true;
            }
            if (((state = ps.getStatus()) == 5 || state == 3 || state == 6) && !ps.isUpdating() && ps.canManuallyUpdate()) {
                update_ok = true;
            }
            if (!ps.canDelete()) continue;
            delete_ok = true;
        }
        boolean needs_sep = false;
        if (found_tracker || found_dht_tracker) {
            MenuItem update_item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)update_item, "GeneralView.label.trackerurlupdate");
            update_item.setEnabled(update_ok);
            update_item.addListener(13, (Listener)new TableSelectedRowsListener(this.tv){

                public void run(TableRowCore row) {
                    for (Object o : sources) {
                        TrackerPeerSource ps = (TrackerPeerSource)o;
                        if (!ps.canManuallyUpdate()) continue;
                        ps.manualUpdate();
                    }
                }
            });
            if (found_tracker) {
                MenuItem edit_item = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)edit_item, "MyTorrentsView.menu.editTracker");
                edit_item.addListener(13, (Listener)new TableSelectedRowsListener(this.tv){

                    public boolean run(TableRowCore[] rows) {
                        final TOTorrent torrent = TrackerView.this.manager.getTorrent();
                        if (torrent != null) {
                            Utils.execSWTThread(new Runnable(){

                                public void run() {
                                    List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                                    new MultiTrackerEditor(null, null, group, new TrackerEditorListener(){

                                        @Override
                                        public void trackersChanged(String str, String str2, List<List<String>> _group) {
                                            TorrentUtils.listToAnnounceGroups(_group, torrent);
                                            try {
                                                TorrentUtils.writeToFile(torrent);
                                            }
                                            catch (Throwable e2) {
                                                Debug.printStackTrace(e2);
                                            }
                                            TRTrackerAnnouncer tc = TrackerView.this.manager.getTrackerClient();
                                            if (tc != null) {
                                                tc.resetTrackerUrl(true);
                                            }
                                        }
                                    }, true, true);
                                }
                            });
                        }
                        return true;
                    }
                });
                TOTorrent torrent = this.manager.getTorrent();
                edit_item.setEnabled(torrent != null && !TorrentUtils.isReallyPrivate(torrent));
            }
            needs_sep = true;
        }
        if (delete_ok) {
            MenuItem delete_item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)delete_item, "Button.remove");
            Utils.setMenuItemImage(delete_item, "delete");
            delete_item.addListener(13, (Listener)new TableSelectedRowsListener(this.tv){

                public void run(TableRowCore row) {
                    for (Object o : sources) {
                        TrackerPeerSource ps = (TrackerPeerSource)o;
                        if (!ps.canDelete()) continue;
                        ps.delete();
                    }
                }
            });
            needs_sep = true;
        }
        if (needs_sep) {
            new MenuItem(menu, 2);
        }
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void trackerPeerSourcesChanged() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TrackerView.this.manager == null || TrackerView.this.tv.isDisposed()) {
                    return;
                }
                TrackerView.this.tv.removeAllTableRows();
                TrackerView.this.addExistingDatasources();
            }
        });
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManager newManager = null;
        if (newDataSource instanceof Object[]) {
            Object[] newDataSources = (Object[])newDataSource;
            if (newDataSources.length == 1) {
                Object temp = ((Object[])newDataSource)[0];
                if (temp instanceof DownloadManager) {
                    newManager = (DownloadManager)temp;
                } else if (temp instanceof DiskManagerFileInfo) {
                    newManager = ((DiskManagerFileInfo)temp).getDownloadManager();
                }
            }
        } else if (newDataSource instanceof DownloadManager) {
            newManager = (DownloadManager)newDataSource;
        } else if (newDataSource instanceof DiskManagerFileInfo) {
            newManager = ((DiskManagerFileInfo)newDataSource).getDownloadManager();
        }
        if (newManager == this.manager) {
            this.tv.setEnabled(this.manager != null);
            return;
        }
        if (this.manager != null) {
            this.manager.removeTPSListener(this);
        }
        this.manager = newManager;
        if (this.tv.isDisposed()) {
            return;
        }
        this.tv.removeAllTableRows();
        this.tv.setEnabled(this.manager != null);
        if (this.manager != null) {
            this.manager.addTPSListener(this);
            this.addExistingDatasources();
        }
    }

    @Override
    public void tableViewInitialized() {
        if (this.manager != null) {
            this.manager.addTPSListener(this);
            this.addExistingDatasources();
            TableViewSWT_TabsCommon tabs = this.tv.getTabsCommon();
            if (tabs != null) {
                tabs.triggerTabViewsDataSourceChanged(this.tv);
            }
        }
    }

    @Override
    public void tableViewDestroyed() {
        if (this.manager != null) {
            this.manager.removeTPSListener(this);
        }
    }

    private void addExistingDatasources() {
        if (this.manager == null || this.tv.isDisposed()) {
            return;
        }
        List<TrackerPeerSource> tps = this.manager.getTrackerPeerSources();
        this.tv.addDataSources((TrackerPeerSource[])tps.toArray(new TrackerPeerSource[tps.size()]));
        this.tv.processDataSourceQueueSync();
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                if (!(event2 instanceof UISWTViewEventImpl)) break;
                String parent = ((UISWTViewEventImpl)event2).getParentID();
                this.enable_tabs = parent != null && parent.equals("TorrentDetailsView");
                break;
            }
            case 3: {
                String id = "DMDetails_Sources";
                if (this.manager != null) {
                    id = this.manager.getTorrent() != null ? id + "." + this.manager.getInternalName() : id + ":" + this.manager.getSize();
                    SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
                    break;
                }
                SelectedContentManager.changeCurrentlySelectedContent(id, null);
                break;
            }
            case 4: {
                SelectedContentManager.clearCurrentlySelectedContent();
            }
        }
        return super.eventOccurred(event2);
    }
}

