/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.clientstats;

import com.aelitis.azureus.util.MapUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncodableObject;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsOverall;

public class ClientStatsDataSource
implements BEncodableObject {
    public String client;
    public int count;
    public int current;
    public long bytesReceived;
    public long bytesDiscarded;
    public long bytesSent;
    public Map<String, Map<String, Object>> perNetworkStats;
    public ClientStatsOverall overall;

    public ClientStatsDataSource() {
        this.perNetworkStats = new HashMap<String, Map<String, Object>>();
    }

    public ClientStatsDataSource(Map loadMap) {
        this.client = MapUtils.getMapString(loadMap, "client", "?");
        this.count = MapUtils.getMapInt(loadMap, "count", 0);
        this.bytesReceived = MapUtils.getMapLong(loadMap, "bytesReceived", 0L);
        this.bytesDiscarded = MapUtils.getMapLong(loadMap, "bytesDiscarded", 0L);
        this.bytesSent = MapUtils.getMapLong(loadMap, "bytesSent", 0L);
        this.perNetworkStats = MapUtils.getMapMap(loadMap, "perNetworkStats", new HashMap());
    }

    public Object toBencodeObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("client", this.client);
        map.put("count", Long.valueOf(this.count));
        map.put("bytesReceived", this.bytesReceived);
        map.put("bytesDiscarded", this.bytesDiscarded);
        map.put("bytesSent", this.bytesSent);
        map.put("perNetworkStats", this.perNetworkStats);
        return map;
    }
}

