/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import java.util.HashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.TrackersUtil;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterface
implements UISWTConfigSection {
    private static final String KEY_PREFIX = "ConfigView.section.interface.";
    private static final String LBLKEY_PREFIX = "ConfigView.label.";
    private ParameterListener decisions_parameter_listener;

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "style";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
        if (this.decisions_parameter_listener != null) {
            COConfigurationManager.removeParameterListener("MessageBoxWindow.decisions", this.decisions_parameter_listener);
        }
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cDisplay = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cDisplay.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cDisplay.setLayout((Layout)layout);
        final PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        Group gAutoOpen = new Group(cDisplay, 0);
        Messages.setLanguageText((Widget)gAutoOpen, "ConfigView.label.autoopen");
        layout = new GridLayout(3, false);
        gAutoOpen.setLayout((Layout)layout);
        gAutoOpen.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)gAutoOpen, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.autoopen.detailstab");
        new BooleanParameter((Composite)gAutoOpen, "Open Details", "ConfigView.label.autoopen.dl");
        new BooleanParameter((Composite)gAutoOpen, "Open Seeding Details", "ConfigView.label.autoopen.cd");
        label = new Label((Composite)gAutoOpen, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.autoopen.downloadbars");
        new BooleanParameter((Composite)gAutoOpen, "Open Bar Incomplete", "ConfigView.label.autoopen.dl");
        new BooleanParameter((Composite)gAutoOpen, "Open Bar Complete", "ConfigView.label.autoopen.cd");
        if (!Constants.isOSX) {
            new BooleanParameter(cDisplay, "Show Status In Window Title", "ConfigView.label.info.in.window.title");
        }
        new BooleanParameter(cDisplay, "Remember transfer bar location", "ConfigView.label.transferbar.remember_location");
        Composite gBarTrans = new Composite(cDisplay, 0);
        layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        gBarTrans.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalIndent = 25;
        gBarTrans.setLayoutData((Object)gridData);
        label = new Label(gBarTrans, 0);
        Messages.setLanguageText((Widget)label, "label.bar.trans");
        new IntParameter(gBarTrans, "Bar Transparency", 0, 100);
        label = new Label(gBarTrans, 0);
        Messages.setLanguageText((Widget)label, "label.show.icon.area");
        new BooleanParameter(gBarTrans, "Transfer Bar Show Icon Area");
        Group gSysTray = new Group(cDisplay, 0);
        Messages.setLanguageText((Widget)gSysTray, "ConfigView.label.systray");
        layout = new GridLayout();
        gSysTray.setLayout((Layout)layout);
        gSysTray.setLayoutData((Object)new GridData(768));
        BooleanParameter est = new BooleanParameter((Composite)gSysTray, "Enable System Tray", "ConfigView.section.interface.enabletray");
        BooleanParameter ctt = new BooleanParameter((Composite)gSysTray, "Close To Tray", "ConfigView.label.closetotray");
        BooleanParameter mtt = new BooleanParameter((Composite)gSysTray, "Minimize To Tray", "ConfigView.label.minimizetotray");
        BooleanParameter esttt = new BooleanParameter((Composite)gSysTray, "ui.systray.tooltip.enable", "ConfigView.label.enableSystrayToolTip");
        BooleanParameter estttd = new BooleanParameter((Composite)gSysTray, "ui.systray.tooltip.next.eta.enable", "ConfigView.label.enableSystrayToolTipNextETA");
        gridData = new GridData();
        gridData.horizontalIndent = 25;
        estttd.setLayoutData(gridData);
        est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(ctt.getControls()));
        est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(mtt.getControls()));
        est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(esttt.getControls()));
        est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(estttd.getControls()));
        esttt.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(estttd.getControls()));
        Group limit_group = new Group(cDisplay, 0);
        Messages.setLanguageText((Widget)limit_group, "ConfigView.label.set_ui_transfer_speeds");
        layout = new GridLayout();
        layout.numColumns = 2;
        limit_group.setLayout((Layout)layout);
        limit_group.setLayoutData((Object)new GridData(768));
        Label limit_group_label = new Label((Composite)limit_group, 64);
        limit_group_label.setLayoutData((Object)Utils.getWrappableLabelGridData(2, 512));
        Messages.setLanguageText((Widget)limit_group_label, "ConfigView.label.set_ui_transfer_speeds.description");
        String[] limit_types = new String[]{"download", "upload"};
        String limit_type_prefix = "config.ui.speed.partitions.manual.";
        for (int i = 0; i < limit_types.length; ++i) {
            final BooleanParameter bp = new BooleanParameter((Composite)limit_group, "config.ui.speed.partitions.manual." + limit_types[i] + ".enabled", false, "ConfigView.label.set_ui_transfer_speeds.description." + limit_types[i]);
            final StringParameter sp = new StringParameter((Composite)limit_group, "config.ui.speed.partitions.manual." + limit_types[i] + ".values", "");
            GenericActionPerformer iaap = new GenericActionPerformer(new Control[0]){

                public void performAction() {
                    sp.getControl().setEnabled(bp.isSelected());
                }
            };
            gridData = new GridData();
            gridData.widthHint = 150;
            sp.setLayoutData(gridData);
            iaap.performAction();
            bp.setAdditionalActionPerformer(iaap);
        }
        new BooleanParameter(cDisplay, "Send Version Info", "ConfigView.label.allowSendVersion");
        Composite cArea = new Composite(cDisplay, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData(768));
        new LinkLabel(cArea, "ConfigView.label.version.info.link", "http://wiki.vuze.com/w/Version.azureusplatform.com");
        if (!Constants.isOSX) {
            BooleanParameter confirm = new BooleanParameter(cArea, "confirmationOnExit", "ConfigView.section.style.confirmationOnExit");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            confirm.setLayoutData(gridData);
        }
        cArea = new Composite(cDisplay, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData(768));
        final Label clear_label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)clear_label, "ConfigView.section.interface.cleardecisions");
        final Button clear_decisions = new Button(cArea, 8);
        Messages.setLanguageText((Widget)clear_decisions, "ConfigView.section.interface.cleardecisionsbutton");
        clear_decisions.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                RememberedDecisionsManager.clearAll();
            }
        });
        Label clear_tracker_label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)clear_tracker_label, "ConfigView.section.interface.cleartrackers");
        Button clear_tracker_button = new Button(cArea, 8);
        Messages.setLanguageText((Widget)clear_tracker_button, "ConfigView.section.interface.cleartrackersbutton");
        clear_tracker_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TrackersUtil.getInstance().clearAllTrackers(true);
            }
        });
        Label clear_save_path_label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)clear_save_path_label, "ConfigView.section.interface.clearsavepaths");
        Button clear_save_path_button = new Button(cArea, 8);
        Messages.setLanguageText((Widget)clear_save_path_button, "ConfigView.section.interface.clearsavepathsbutton");
        clear_save_path_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                COConfigurationManager.setParameter("saveTo_list", new StringListImpl());
            }
        });
        this.decisions_parameter_listener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                if (clear_decisions.isDisposed()) {
                    COConfigurationManager.removeParameterListener("MessageBoxWindow.decisions", this);
                } else {
                    boolean enabled = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap()).size() > 0;
                    clear_label.setEnabled(enabled);
                    clear_decisions.setEnabled(enabled);
                }
            }
        };
        this.decisions_parameter_listener.parameterChanged(null);
        COConfigurationManager.addParameterListener("MessageBoxWindow.decisions", this.decisions_parameter_listener);
        if (platform.hasCapability(PlatformManagerCapabilities.RegisterFileAssociations)) {
            Composite cResetAssoc = new Composite(cArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            cResetAssoc.setLayout((Layout)layout);
            cResetAssoc.setLayoutData((Object)new GridData());
            label = new Label(cResetAssoc, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.interface.resetassoc");
            Button reset = new Button(cResetAssoc, 8);
            Messages.setLanguageText((Widget)reset, "ConfigView.section.interface.resetassocbutton");
            reset.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    try {
                        platform.registerApplication();
                    }
                    catch (PlatformManagerException e) {
                        Logger.log(new LogAlert(false, "Failed to register application", e));
                    }
                }
            });
            new BooleanParameter(cArea, "config.interface.checkassoc", "ConfigView.section.interface.checkassoc");
        }
        return cDisplay;
    }
}

