/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableColumnCoreCreationListener;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.columnsetup.ColumnTC_ChosenColumn;
import org.gudy.azureus2.ui.swt.views.columnsetup.ColumnTC_NameInfo;
import org.gudy.azureus2.ui.swt.views.columnsetup.ColumnTC_Sample;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AlertsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AvgAvailItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.BadAvailTimeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ColumnDoneWithDND;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ColumnFileCount;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ColumnSizeWithDND;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ColumnTorrentSpeed;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CommentIconItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CommentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CompletionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateAddedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateCompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateFileCompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateLastActiveItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownSpeedLimitItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ETAItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.FileExtensionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.FilesDoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.HealthItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.IPFilterItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.MaxSRItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.MaxUploadsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.MergedDataItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.MinSRItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.NetworksItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.OnlyCDing4Item;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeakDownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeakUpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeerSourcesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RankItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RemainingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SavePathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SecondsDownloadingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SecondsSeedingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SeedToPeerRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SeedsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SessionDownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SessionUpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ShareRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ShareRatioProgressItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SmoothedDownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SmoothedETAItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SmoothedUpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SwarmAverageCompletion;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SwarmAverageSpeed;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TagColorsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TagsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TimeSinceDownloadItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TimeSinceUploadItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TorrentCreateDateItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TorrentPathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TotalSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNextAccessItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerStatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpSpeedLimitItem;

public class TableColumnCreator {
    public static int DATE_COLUMN_WIDTH = 110;

    public static TableColumnCore[] createIncompleteDM(String tableID) {
        String[] defaultVisibleOrder = new String[]{"health", "#", "name", "TorrentStream", "azsubs.ui.column.subs", "RatingColumn", "Info", "commenticon", "size", "down", "done", "status", "seeds", "peers", "downspeed", "upspeed", "eta", "shareRatio", "tracker"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeIncomplete.class, tableID);
        tcManager.setDefaultColumnNames(tableID, defaultVisibleOrder);
        if (!tcManager.loadTableColumnSettings(DownloadTypeIncomplete.class, tableID) || TableColumnCreator.areNoneVisible(mapTCs)) {
            TableColumnCreator.setVisibility(mapTCs, defaultVisibleOrder);
            RankItem tc = (RankItem)mapTCs.get("#");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "#");
                tc.setSortAscending(true);
            }
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createCompleteDM(String tableID) {
        String[] defaultVisibleOrder = new String[]{"health", "#", "SeedingRank", "name", "azsubs.ui.column.subs", "RatingColumn", "Info", "RateIt", "commenticon", "size", "status", "seeds", "peers", "upspeed", "shareRatio", "up", "tracker"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeComplete.class, tableID);
        tcManager.setDefaultColumnNames(tableID, defaultVisibleOrder);
        if (!tcManager.loadTableColumnSettings(DownloadTypeComplete.class, tableID) || TableColumnCreator.areNoneVisible(mapTCs)) {
            TableColumnCreator.setVisibility(mapTCs, defaultVisibleOrder);
            RankItem tc = (RankItem)mapTCs.get("#");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "#");
                tc.setSortAscending(true);
            }
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    private static boolean areNoneVisible(Map mapTCs) {
        boolean noneVisible = true;
        for (TableColumn tc : mapTCs.values()) {
            if (!tc.isVisible()) continue;
            noneVisible = false;
            break;
        }
        return noneVisible;
    }

    private static void setVisibility(Map mapTCs, String[] defaultVisibleOrder) {
        for (TableColumnCore tc : mapTCs.values()) {
            Long force_visible = (Long)tc.getUserData("ud_fv");
            if (force_visible != null && force_visible != 0L) continue;
            tc.setVisible(false);
        }
        for (int i = 0; i < defaultVisibleOrder.length; ++i) {
            String id = defaultVisibleOrder[i];
            TableColumnCore tc = (TableColumnCore)mapTCs.get(id);
            if (tc == null) continue;
            tc.setVisible(true);
            tc.setPositionNoShift(i);
        }
    }

    public static void initCoreColumns() {
        final LightHashMap c = new LightHashMap(50);
        Class<TableColumn> tc = TableColumn.class;
        c.put("#", new cInfo(RankItem.class, RankItem.DATASOURCE_TYPE));
        c.put("name", new cInfo(NameItem.class, NameItem.DATASOURCE_TYPE));
        c.put("size", new cInfo(SizeItem.class, SizeItem.DATASOURCE_TYPE));
        c.put("sizewithdnd", new cInfo(ColumnSizeWithDND.class, ColumnSizeWithDND.DATASOURCE_TYPE));
        c.put("done", new cInfo(DoneItem.class, DoneItem.DATASOURCE_TYPE));
        c.put("donewithdnd", new cInfo(ColumnDoneWithDND.class, ColumnDoneWithDND.DATASOURCE_TYPE));
        c.put("status", new cInfo(StatusItem.class, StatusItem.DATASOURCE_TYPE));
        c.put("eta", new cInfo(ETAItem.class, ETAItem.DATASOURCE_TYPE));
        c.put("health", new cInfo(HealthItem.class, HealthItem.DATASOURCE_TYPE));
        c.put("commenticon", new cInfo(CommentIconItem.class, CommentIconItem.DATASOURCE_TYPE));
        c.put("down", new cInfo(DownItem.class, DownItem.DATASOURCE_TYPE));
        c.put("seeds", new cInfo(SeedsItem.class, SeedsItem.DATASOURCE_TYPE));
        c.put("peers", new cInfo(PeersItem.class, PeersItem.DATASOURCE_TYPE));
        c.put("downspeed", new cInfo(DownSpeedItem.class, DownSpeedItem.DATASOURCE_TYPE));
        c.put("upspeed", new cInfo(UpSpeedItem.class, UpSpeedItem.DATASOURCE_TYPE));
        c.put("maxupspeed", new cInfo(UpSpeedLimitItem.class, UpSpeedLimitItem.DATASOURCE_TYPE));
        c.put("tracker", new cInfo(TrackerStatusItem.class, TrackerStatusItem.DATASOURCE_TYPE));
        c.put("completed", new cInfo(CompletedItem.class, CompletedItem.DATASOURCE_TYPE));
        c.put("shareRatio", new cInfo(ShareRatioItem.class, ShareRatioItem.DATASOURCE_TYPE));
        c.put("sr_prog", new cInfo(ShareRatioProgressItem.class, ShareRatioProgressItem.DATASOURCE_TYPE));
        c.put("up", new cInfo(UpItem.class, UpItem.DATASOURCE_TYPE));
        c.put("remaining", new cInfo(RemainingItem.class, RemainingItem.DATASOURCE_TYPE));
        c.put("pieces", new cInfo(PiecesItem.class, PiecesItem.DATASOURCE_TYPE));
        c.put("completion", new cInfo(CompletionItem.class, CompletionItem.DATASOURCE_TYPE));
        c.put("comment", new cInfo(CommentItem.class, CommentItem.DATASOURCE_TYPE));
        c.put("maxuploads", new cInfo(MaxUploadsItem.class, MaxUploadsItem.DATASOURCE_TYPE));
        c.put("totalspeed", new cInfo(TotalSpeedItem.class, TotalSpeedItem.DATASOURCE_TYPE));
        c.put("filesdone", new cInfo(FilesDoneItem.class, FilesDoneItem.DATASOURCE_TYPE));
        c.put("fileext", new cInfo(FileExtensionItem.class, FileExtensionItem.DATASOURCE_TYPE));
        c.put("savepath", new cInfo(SavePathItem.class, SavePathItem.DATASOURCE_TYPE));
        c.put("torrentpath", new cInfo(TorrentPathItem.class, TorrentPathItem.DATASOURCE_TYPE));
        c.put("category", new cInfo(CategoryItem.class, CategoryItem.DATASOURCE_TYPE));
        c.put("tags", new cInfo(TagsItem.class, TagsItem.DATASOURCE_TYPE));
        c.put("tag_colors", new cInfo(TagColorsItem.class, TagColorsItem.DATASOURCE_TYPE));
        c.put("networks", new cInfo(NetworksItem.class, NetworksItem.DATASOURCE_TYPE));
        c.put("peersources", new cInfo(PeerSourcesItem.class, PeerSourcesItem.DATASOURCE_TYPE));
        c.put("availability", new cInfo(AvailabilityItem.class, AvailabilityItem.DATASOURCE_TYPE));
        c.put("AvgAvail", new cInfo(AvgAvailItem.class, AvgAvailItem.DATASOURCE_TYPE));
        c.put("secondsseeding", new cInfo(SecondsSeedingItem.class, SecondsSeedingItem.DATASOURCE_TYPE));
        c.put("secondsdownloading", new cInfo(SecondsDownloadingItem.class, SecondsDownloadingItem.DATASOURCE_TYPE));
        c.put("timesincedownload", new cInfo(TimeSinceDownloadItem.class, TimeSinceDownloadItem.DATASOURCE_TYPE));
        c.put("timesinceupload", new cInfo(TimeSinceUploadItem.class, TimeSinceUploadItem.DATASOURCE_TYPE));
        c.put("OnlyCDing4", new cInfo(OnlyCDing4Item.class, OnlyCDing4Item.DATASOURCE_TYPE));
        c.put("trackernextaccess", new cInfo(TrackerNextAccessItem.class, TrackerNextAccessItem.DATASOURCE_TYPE));
        c.put("trackername", new cInfo(TrackerNameItem.class, TrackerNameItem.DATASOURCE_TYPE));
        c.put("seed_to_peer_ratio", new cInfo(SeedToPeerRatioItem.class, SeedToPeerRatioItem.DATASOURCE_TYPE));
        c.put("maxdownspeed", new cInfo(DownSpeedLimitItem.class, DownSpeedLimitItem.DATASOURCE_TYPE));
        c.put("swarm_average_speed", new cInfo(SwarmAverageSpeed.class, SwarmAverageSpeed.DATASOURCE_TYPE));
        c.put("swarm_average_completion", new cInfo(SwarmAverageCompletion.class, SwarmAverageCompletion.DATASOURCE_TYPE));
        c.put("bad_avail_time", new cInfo(BadAvailTimeItem.class, BadAvailTimeItem.DATASOURCE_TYPE));
        c.put("filecount", new cInfo(ColumnFileCount.class, ColumnFileCount.DATASOURCE_TYPE));
        c.put("torrentspeed", new cInfo(ColumnTorrentSpeed.class, ColumnTorrentSpeed.DATASOURCE_TYPE));
        c.put("DateCompleted", new cInfo(DateCompletedItem.class, DateCompletedItem.DATASOURCE_TYPE));
        c.put("DateFileCompleted", new cInfo(DateFileCompletedItem.class, DateFileCompletedItem.DATASOURCE_TYPE));
        c.put("date_added", new cInfo(DateAddedItem.class, DateAddedItem.DATASOURCE_TYPE));
        c.put("DateTorrentLastActive", new cInfo(DateLastActiveItem.class, DateLastActiveItem.DATASOURCE_TYPE));
        c.put("ipfilter", new cInfo(IPFilterItem.class, IPFilterItem.DATASOURCE_TYPE));
        c.put("alerts", new cInfo(AlertsItem.class, AlertsItem.DATASOURCE_TYPE));
        c.put("torrent_created", new cInfo(TorrentCreateDateItem.class, TorrentCreateDateItem.DATASOURCE_TYPE));
        c.put("TableColumnNameInfo", new cInfo(ColumnTC_NameInfo.class, tc));
        c.put("TableColumnSample", new cInfo(ColumnTC_Sample.class, tc));
        c.put("TableColumnChosenColumn", new cInfo(ColumnTC_ChosenColumn.class, tc));
        c.put("peakup", new cInfo(PeakUpItem.class, PeakUpItem.DATASOURCE_TYPE));
        c.put("peakdown", new cInfo(PeakDownItem.class, PeakDownItem.DATASOURCE_TYPE));
        c.put("smoothup", new cInfo(SmoothedUpItem.class, SmoothedUpItem.DATASOURCE_TYPE));
        c.put("smoothdown", new cInfo(SmoothedDownItem.class, SmoothedDownItem.DATASOURCE_TYPE));
        c.put("smootheta", new cInfo(SmoothedETAItem.class, SmoothedETAItem.DATASOURCE_TYPE));
        c.put("min_sr", new cInfo(MinSRItem.class, MinSRItem.DATASOURCE_TYPE));
        c.put("max_sr", new cInfo(MaxSRItem.class, MaxSRItem.DATASOURCE_TYPE));
        c.put("sessionup", new cInfo(SessionUpItem.class, SessionUpItem.DATASOURCE_TYPE));
        c.put("sessiondown", new cInfo(SessionDownItem.class, SessionDownItem.DATASOURCE_TYPE));
        c.put("mergeddata", new cInfo(MergedDataItem.class, MergedDataItem.DATASOURCE_TYPE));
        TableColumnManager tcManager = TableColumnManager.getInstance();
        TableColumnCoreCreationListener tcCreator = new TableColumnCoreCreationListener(){

            public TableColumnCore createTableColumnCore(Class forDataSourceType, String tableID, String columnID) {
                cInfo info = (cInfo)c.get(columnID);
                try {
                    Constructor constructor = info.cla.getDeclaredConstructor(String.class);
                    TableColumnCore column = (TableColumnCore)constructor.newInstance(tableID);
                    return column;
                }
                catch (Exception e) {
                    Debug.out(e);
                    return null;
                }
            }

            public void tableColumnCreated(TableColumn column) {
            }
        };
        for (String id : c.keySet()) {
            cInfo info = (cInfo)c.get(id);
            tcManager.registerColumn(info.forDataSourceType, id, tcCreator);
        }
    }

    private static class cInfo {
        public Class cla;
        public Class forDataSourceType;

        public cInfo(Class cla, Class forDataSourceType) {
            this.cla = cla;
            this.forDataSourceType = forDataSourceType;
        }
    }
}

