/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.archivedfiles;

import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class SizeItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener {
    public SizeItem(String tableID) {
        super("size", 2, -2, 70, tableID);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        DownloadStub.DownloadStubFile fileInfo2 = (DownloadStub.DownloadStubFile)cell.getDataSource();
        long size = fileInfo2 == null ? 0L : fileInfo2.getLength();
        if (!cell.setSortValue(size) && cell.isValid()) {
            return;
        }
        if (size < 0L) {
            cell.setText("(" + DisplayFormatters.formatByteCountToKiBEtc(-size) + ")");
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(size));
        }
    }

    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }
}

