/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import java.net.URL;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerCellUtils;

public class TrackerNameItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "trackername";

    public TrackerNameItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 120, sTableID);
        this.setRefreshInterval(5);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"tracker"});
        info.setProficiency((byte)1);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String name = "";
        if (dm != null && dm.getTorrent() != null) {
            TOTorrent torrent = dm.getTorrent();
            name = TrackerNameItem.getTrackerName(torrent);
        }
        if (cell.setText(name) || !cell.isValid()) {
            TrackerCellUtils.updateColor(cell, dm, false);
        }
    }

    public static String getTrackerName(TOTorrent torrent) {
        String host;
        TOTorrentAnnounceURLSet[] sets;
        String name = "";
        Set<String> pref_names = MyTorrentsView.preferred_tracker_names;
        URL url = null;
        if (pref_names != null && (sets = torrent.getAnnounceURLGroup().getAnnounceURLSets()).length > 0) {
            String host2 = torrent.getAnnounceURL().getHost();
            if (pref_names.contains(host2)) {
                url = torrent.getAnnounceURL();
            } else {
                for (TOTorrentAnnounceURLSet set : sets) {
                    URL[] urls;
                    for (URL u : urls = set.getAnnounceURLs()) {
                        if (!pref_names.contains(u.getHost())) continue;
                        url = u;
                        break;
                    }
                    if (url != null) break;
                }
            }
        }
        if (url == null) {
            url = torrent.getAnnounceURL();
        }
        if ((host = url.getHost()).endsWith(".dht")) {
            name = "dht";
        } else {
            String[] parts = host.split("\\.");
            int used = 0;
            for (int i = parts.length - 1; i >= 0 && used <= 4; ++used, --i) {
                String chunk = parts[i];
                if (used >= 2 && chunk.length() >= 11) break;
                name = used == 0 ? chunk : chunk + "." + name;
            }
        }
        name = name.equals(host) ? host : StringInterner.intern(name);
        return name;
    }

    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        cell.setToolTip(TrackerCellUtils.getTooltipText(cell, dm, false));
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

